/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.McCostParamsBuilder;

public class McCostParams {
    public static final double DEFAULT_TRANSIT_RELUCTANCE = 1.0;
    public static final McCostParams DEFAULTS = new McCostParams();
    private final int boardCost;
    private final int transferCost;
    private final double[] transitReluctanceFactors;
    private final double waitReluctanceFactor;

    private McCostParams() {
        this.boardCost = 600;
        this.transferCost = 0;
        this.transitReluctanceFactors = null;
        this.waitReluctanceFactor = 1.0;
    }

    McCostParams(McCostParamsBuilder builder) {
        this.boardCost = builder.boardCost();
        this.transferCost = builder.transferCost();
        this.transitReluctanceFactors = builder.transitReluctanceFactors();
        this.waitReluctanceFactor = builder.waitReluctanceFactor();
    }

    public int boardCost() {
        return this.boardCost;
    }

    public int transferCost() {
        return this.transferCost;
    }

    @Nullable
    public double[] transitReluctanceFactors() {
        return this.transitReluctanceFactors;
    }

    public double waitReluctanceFactor() {
        return this.waitReluctanceFactor;
    }

    public String toString() {
        return ToStringBuilder.of(McCostParams.class).addNum("boardCost", (Number)this.boardCost, 0).addNum("transferCost", (Number)this.transferCost, 0).addNum("waitReluctanceFactor", (Number)this.waitReluctanceFactor, 1.0).addDoubles("transitReluctanceFactors", this.transitReluctanceFactors, 1.0).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        McCostParams that = (McCostParams)o;
        return this.boardCost == that.boardCost && this.transferCost == that.transferCost && Double.compare(that.waitReluctanceFactor, this.waitReluctanceFactor) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.boardCost, this.transferCost, this.waitReluctanceFactor);
    }
}

