/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.FactorStrategy;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.IndexBasedFactorStrategy;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.McCostParams;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.SingleValueFactorStrategy;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransferConstraint;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;

public final class DefaultCostCalculator
implements CostCalculator {
    private final int boardCostOnly;
    private final int transferCostOnly;
    private final int boardAndTransferCost;
    private final int waitFactor;
    private final FactorStrategy transitFactors;
    private final int[] stopVisitCost;

    public DefaultCostCalculator(int boardCost, int transferCost, double waitReluctanceFactor, @Nullable double[] transitReluctanceFactors, @Nullable int[] stopVisitCost) {
        this.boardCostOnly = RaptorCostConverter.toRaptorCost(boardCost);
        this.transferCostOnly = RaptorCostConverter.toRaptorCost(transferCost);
        this.boardAndTransferCost = this.transferCostOnly + this.boardCostOnly;
        this.waitFactor = RaptorCostConverter.toRaptorCost(waitReluctanceFactor);
        this.transitFactors = transitReluctanceFactors == null ? new SingleValueFactorStrategy(1.0) : new IndexBasedFactorStrategy(transitReluctanceFactors);
        this.stopVisitCost = stopVisitCost;
    }

    public DefaultCostCalculator(McCostParams params, int[] stopVisitCost) {
        this(params.boardCost(), params.transferCost(), params.waitReluctanceFactor(), params.transitReluctanceFactors(), stopVisitCost);
    }

    @Override
    public int boardingCost(boolean firstBoarding, int prevArrivalTime, int boardStop, int boardTime, RaptorTripSchedule trip, RaptorTransferConstraint transferConstraints) {
        if (transferConstraints.isRegularTransfer()) {
            return this.boardingCostRegularTransfer(firstBoarding, prevArrivalTime, boardStop, boardTime);
        }
        return this.boardingCostConstrainedTransfer(prevArrivalTime, boardStop, boardTime, trip.transitReluctanceFactorIndex(), firstBoarding, transferConstraints);
    }

    @Override
    public int onTripRelativeRidingCost(int boardTime, int transitFactorIndex) {
        return -boardTime * this.transitFactors.factor(transitFactorIndex);
    }

    @Override
    public int transitArrivalCost(int boardCost, int alightSlack, int transitTime, int transitFactorIndex, int toStop) {
        int cost = boardCost + this.transitFactors.factor(transitFactorIndex) * transitTime + this.waitFactor * alightSlack;
        if (this.stopVisitCost != null) {
            cost += this.stopVisitCost[toStop];
        }
        return cost;
    }

    @Override
    public int waitCost(int waitTimeInSeconds) {
        return this.waitFactor * waitTimeInSeconds;
    }

    @Override
    public int calculateMinCost(int minTravelTime, int minNumTransfers) {
        return this.boardCostOnly + this.boardAndTransferCost * minNumTransfers + this.transitFactors.minFactor() * minTravelTime;
    }

    @Override
    public int costEgress(RaptorTransfer egress) {
        return egress.hasRides() ? egress.generalizedCost() + this.transferCostOnly : egress.generalizedCost();
    }

    public int boardingCostRegularTransfer(boolean firstBoarding, int prevArrivalTime, int boardStop, int boardTime) {
        int boardWaitTime = boardTime - prevArrivalTime;
        int cost = this.waitFactor * boardWaitTime;
        cost += firstBoarding ? this.boardCostOnly : this.boardAndTransferCost;
        if (this.stopVisitCost != null) {
            cost += this.stopVisitCost[boardStop];
        }
        return cost;
    }

    private int boardingCostConstrainedTransfer(int prevArrivalTime, int boardStop, int boardTime, int transitReluctanceIndex, boolean firstBoarding, RaptorTransferConstraint txConstraints) {
        TransferConstraint tx = (TransferConstraint)txConstraints;
        if (tx.isStaySeated()) {
            int boardWaitTime = boardTime - prevArrivalTime;
            int transitReluctance = this.transitFactors.factor(transitReluctanceIndex);
            return transitReluctance * boardWaitTime;
        }
        if (tx.isGuaranteed()) {
            int boardWaitTime = boardTime - prevArrivalTime;
            int cost = this.waitFactor * boardWaitTime;
            if (this.stopVisitCost != null) {
                cost += this.stopVisitCost[boardStop];
            }
            return cost;
        }
        return this.boardingCostRegularTransfer(firstBoarding, prevArrivalTime, boardStop, boardTime);
    }
}

