/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer;

import java.util.function.IntFunction;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.Trip;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.StopIndexForRaptor;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferPointMatcher;

final class TransferPointForPatternFactory {
    private TransferPointForPatternFactory() {
    }

    static TransferPointMatcher createTransferPointForPattern(Station station, StopIndexForRaptor stopIndex) {
        return new StationSP(stopIndex::stopByIndex, station);
    }

    static TransferPointMatcher createTransferPointForPattern(int stopIndex) {
        return new StopSP(stopIndex);
    }

    static TransferPointMatcher createTransferPointForPattern(Route route, int sourceStopIndex) {
        return new RouteSP(route, sourceStopIndex);
    }

    static TransferPointMatcher createTransferPointForPattern(Trip trip, int sourceStopIndex) {
        return new TripSP(trip, sourceStopIndex);
    }

    private static class TripSP
    implements TransferPointMatcher {
        private final Trip trip;
        private final int stopIndex;

        private TripSP(Trip trip, int stopIndex) {
            this.trip = trip;
            this.stopIndex = stopIndex;
        }

        @Override
        public boolean match(int stopIndex, Trip trip) {
            return this.stopIndex == stopIndex && this.trip == trip;
        }
    }

    private static class RouteSP
    implements TransferPointMatcher {
        private final Route route;
        private final int stopIndex;

        private RouteSP(Route route, int stopIndex) {
            this.route = route;
            this.stopIndex = stopIndex;
        }

        @Override
        public boolean match(int stopIndex, Trip trip) {
            return this.stopIndex == stopIndex && this.route == trip.getRoute();
        }
    }

    private static class StopSP
    implements TransferPointMatcher {
        private final int stopIndex;

        private StopSP(int stopIndex) {
            this.stopIndex = stopIndex;
        }

        @Override
        public boolean match(int stopIndex, Trip trip) {
            return this.stopIndex == stopIndex;
        }
    }

    private static class StationSP
    implements TransferPointMatcher {
        private final IntFunction<StopLocation> toStop;
        private final Station station;

        private StationSP(IntFunction<StopLocation> toStop, Station station) {
            this.toStop = toStop;
            this.station = station;
        }

        @Override
        public boolean match(int stopIndex, Trip trip) {
            return this.station == this.toStop.apply(stopIndex).getParentStation();
        }
    }
}

