/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.RouteStationTransferPoint;
import org.opentripplanner.model.transfer.RouteStopTransferPoint;
import org.opentripplanner.model.transfer.StationTransferPoint;
import org.opentripplanner.model.transfer.StopTransferPoint;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.model.transfer.TripTransferPoint;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.StopIndexForRaptor;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternWithRaptorStopIndexes;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPattern;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferPointForPatternFactory;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferPointMatcher;

public class TransferIndexGenerator {
    private static final boolean BOARD = true;
    private static final boolean ALIGHT = false;
    private final Collection<ConstrainedTransfer> constrainedTransfers;
    private final Map<Station, Set<TripPatternWithRaptorStopIndexes>> patternsByStation = new HashMap<Station, Set<TripPatternWithRaptorStopIndexes>>();
    private final Map<StopLocation, Set<TripPatternWithRaptorStopIndexes>> patternsByStop = new HashMap<StopLocation, Set<TripPatternWithRaptorStopIndexes>>();
    private final Map<Route, Set<TripPatternWithRaptorStopIndexes>> patternsByRoute = new HashMap<Route, Set<TripPatternWithRaptorStopIndexes>>();
    private final Map<Trip, Set<TripPatternWithRaptorStopIndexes>> patternsByTrip = new HashMap<Trip, Set<TripPatternWithRaptorStopIndexes>>();
    private final StopIndexForRaptor stopIndex;

    public TransferIndexGenerator(Collection<ConstrainedTransfer> constrainedTransfers, Collection<TripPatternWithRaptorStopIndexes> tripPatterns, StopIndexForRaptor stopIndex) {
        this.constrainedTransfers = constrainedTransfers;
        this.stopIndex = stopIndex;
        this.setupPatternByTripIndex(tripPatterns);
    }

    public void generateTransfers() {
        for (ConstrainedTransfer tx : this.constrainedTransfers) {
            TransferConstraint c = tx.getTransferConstraint();
            if (!c.includeInRaptorRouting()) continue;
            this.findTPoints(tx.getFrom(), false).stream().filter(TPoint::canAlight).forEachOrdered(fromPoint -> {
                for (TPoint toPoint : this.findTPoints(tx.getTo(), true)) {
                    if (!toPoint.canBoard() || fromPoint.equals(toPoint)) continue;
                    fromPoint.addTransferConstraints(tx, toPoint);
                }
            });
        }
        this.sealConstrainedTransfers();
    }

    private void sealConstrainedTransfers() {
        for (Set<TripPatternWithRaptorStopIndexes> patterns : this.patternsByRoute.values()) {
            for (TripPatternWithRaptorStopIndexes pattern : patterns) {
                pattern.sealConstrainedTransfers();
            }
        }
    }

    private void setupPatternByTripIndex(Collection<TripPatternWithRaptorStopIndexes> tripPatterns) {
        for (TripPatternWithRaptorStopIndexes pattern : tripPatterns) {
            TripPattern tripPattern = pattern.getPattern();
            this.patternsByRoute.computeIfAbsent(tripPattern.getRoute(), t -> new HashSet()).add(pattern);
            tripPattern.scheduledTripsAsStream().forEach(trip -> this.patternsByTrip.computeIfAbsent((Trip)trip, t -> new HashSet()).add(pattern));
            for (StopLocation stop : tripPattern.getStops()) {
                this.patternsByStop.computeIfAbsent(stop, t -> new HashSet()).add(pattern);
                Station station = stop.getParentStation();
                if (station == null) continue;
                this.patternsByStation.computeIfAbsent(station, t -> new HashSet()).add(pattern);
            }
        }
    }

    public void addRealtimeTrip(TripPatternWithRaptorStopIndexes pattern, List<Trip> trips) {
        TripPattern tripPattern = pattern.getPattern();
        this.patternsByRoute.computeIfAbsent(tripPattern.getRoute(), t -> new HashSet()).add(pattern);
        for (Trip trip : trips) {
            this.patternsByTrip.computeIfAbsent(trip, t -> new HashSet()).add(pattern);
        }
        for (StopLocation stop : tripPattern.getStops()) {
            this.patternsByStop.computeIfAbsent(stop, t -> new HashSet()).add(pattern);
            Station station = stop.getParentStation();
            if (station == null) continue;
            this.patternsByStation.computeIfAbsent(station, t -> new HashSet()).add(pattern);
        }
    }

    private Collection<TPoint> findTPoints(TransferPoint txPoint, boolean boarding) {
        if (txPoint.isStationTransferPoint()) {
            return this.findTPoints(txPoint.asStationTransferPoint());
        }
        if (txPoint.isStopTransferPoint()) {
            return this.findTPoints(txPoint.asStopTransferPoint());
        }
        if (txPoint.isRouteStationTransferPoint()) {
            return this.findTPoint(txPoint.asRouteStationTransferPoint(), boarding);
        }
        if (txPoint.isRouteStopTransferPoint()) {
            return this.findTPoint(txPoint.asRouteStopTransferPoint(), boarding);
        }
        return this.findTPoints(txPoint.asTripTransferPoint());
    }

    private List<TPoint> findTPoints(StationTransferPoint point) {
        Station station = point.getStation();
        Set<TripPatternWithRaptorStopIndexes> patterns = this.patternsByStation.get(station);
        if (patterns == null) {
            return List.of();
        }
        TransferPointMatcher sourcePoint = TransferPointForPatternFactory.createTransferPointForPattern(station, this.stopIndex);
        ArrayList<TPoint> result = new ArrayList<TPoint>();
        for (TripPatternWithRaptorStopIndexes pattern : patterns) {
            TripPattern tripPattern = pattern.getPattern();
            for (int pos = 0; pos < tripPattern.numberOfStops(); ++pos) {
                if (point.getStation() != tripPattern.getStop(pos).getParentStation()) continue;
                result.add(new TPoint(pattern, sourcePoint, null, pos));
            }
        }
        return result;
    }

    private List<TPoint> findTPoints(StopTransferPoint point) {
        StopLocation stop = point.asStopTransferPoint().getStop();
        Set<TripPatternWithRaptorStopIndexes> patterns = this.patternsByStop.get(stop);
        if (patterns == null) {
            return List.of();
        }
        TransferPointMatcher sourcePoint = TransferPointForPatternFactory.createTransferPointForPattern(this.stopIndex.indexOf(stop));
        ArrayList<TPoint> result = new ArrayList<TPoint>();
        for (TripPatternWithRaptorStopIndexes pattern : patterns) {
            TripPattern p = pattern.getPattern();
            for (int pos = 0; pos < p.numberOfStops(); ++pos) {
                if (point.getStop() != p.getStop(pos)) continue;
                result.add(new TPoint(pattern, sourcePoint, null, pos));
            }
        }
        return result;
    }

    private List<TPoint> findTPoint(RouteStationTransferPoint point, boolean boarding) {
        return this.findTPointForRoute(point.getRoute(), boarding ? p -> p.findBoardingStopPositionInPattern(point.getStation()) : p -> p.findAlightStopPositionInPattern(point.getStation()));
    }

    private List<TPoint> findTPoint(RouteStopTransferPoint point, boolean boarding) {
        return this.findTPointForRoute(point.getRoute(), boarding ? p -> p.findBoardingStopPositionInPattern(point.getStop()) : p -> p.findAlightStopPositionInPattern(point.getStop()));
    }

    private List<TPoint> findTPointForRoute(Route route, ToIntFunction<TripPattern> resolveStopPosInPattern) {
        Set<TripPatternWithRaptorStopIndexes> patterns = this.patternsByRoute.get(route);
        if (patterns == null) {
            return List.of();
        }
        ArrayList<TPoint> points = new ArrayList<TPoint>();
        for (TripPatternWithRaptorStopIndexes pattern : patterns) {
            int stopPosInPattern = resolveStopPosInPattern.applyAsInt(pattern.getPattern());
            if (stopPosInPattern < 0) continue;
            int stopIndex = pattern.stopIndex(stopPosInPattern);
            TransferPointMatcher sourcePoint = TransferPointForPatternFactory.createTransferPointForPattern(route, stopIndex);
            points.add(new TPoint(pattern, sourcePoint, null, stopPosInPattern));
        }
        return points;
    }

    private List<TPoint> findTPoints(TripTransferPoint point) {
        Trip trip = point.getTrip();
        Set<TripPatternWithRaptorStopIndexes> patterns = this.patternsByTrip.get(trip);
        int stopPosInPattern = point.getStopPositionInPattern();
        int stopIndex = patterns.iterator().next().stopIndex(stopPosInPattern);
        TransferPointMatcher sourcePoint = TransferPointForPatternFactory.createTransferPointForPattern(trip, stopIndex);
        return patterns.stream().map(p -> new TPoint((TripPatternWithRaptorStopIndexes)p, sourcePoint, trip, stopPosInPattern)).collect(Collectors.toList());
    }

    private static class TPoint {
        TripPatternWithRaptorStopIndexes pattern;
        TransferPointMatcher sourcePoint;
        Trip trip;
        int stopPosition;

        private TPoint(TripPatternWithRaptorStopIndexes pattern, TransferPointMatcher sourcePoint, Trip trip, int stopPosition) {
            this.pattern = pattern;
            this.sourcePoint = sourcePoint;
            this.trip = trip;
            this.stopPosition = stopPosition;
        }

        boolean canBoard() {
            int lastStopPosition = this.pattern.getPattern().numberOfStops() - 1;
            return this.stopPosition != lastStopPosition && this.pattern.getPattern().canBoard(this.stopPosition);
        }

        boolean canAlight() {
            return this.stopPosition != 0 && this.pattern.getPattern().canAlight(this.stopPosition);
        }

        void addTransferConstraints(ConstrainedTransfer tx, TPoint to) {
            int rank = tx.getSpecificityRanking();
            TransferConstraint c = tx.getTransferConstraint();
            to.pattern.addTransferConstraintsForwardSearch(to.stopPosition, new TransferForPattern(this.sourcePoint, to.trip, rank, c));
            this.pattern.addTransferConstraintsReverseSearch(this.stopPosition, new TransferForPattern(to.sourcePoint, this.trip, rank, c));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TPoint)) {
                return false;
            }
            TPoint tPoint = (TPoint)o;
            return this.stopPosition == tPoint.stopPosition && Objects.equals(this.pattern, tPoint.pattern) && Objects.equals(this.trip, tPoint.trip);
        }

        public int hashCode() {
            return Objects.hash(this.pattern, this.trip, this.stopPosition);
        }
    }
}

