/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer;

import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedBoardingSearchForward;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedBoardingSearchReverse;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedBoardingSearchStrategy;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedTransferBoarding;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPattern;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPatternByStopPos;
import org.opentripplanner.transit.raptor.api.transit.IntIterator;
import org.opentripplanner.transit.raptor.api.transit.RaptorConstrainedTripScheduleBoardingSearch;
import org.opentripplanner.transit.raptor.api.transit.RaptorTimeTable;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleBoardOrAlightEvent;
import org.opentripplanner.util.OTPFeature;

public final class ConstrainedBoardingSearch
implements RaptorConstrainedTripScheduleBoardingSearch<TripSchedule> {
    private static final int ABORT_SEARCH_AFTER_N_VAILD_NORMAL_TRIPS = 5;
    private static final ConstrainedBoardingSearchStrategy FORWARD_STRATEGY = new ConstrainedBoardingSearchForward();
    private static final ConstrainedBoardingSearchStrategy REVERSE_STRATEGY = new ConstrainedBoardingSearchReverse();
    private final ConstrainedBoardingSearchStrategy searchStrategy;
    private final TransferForPatternByStopPos transfers;
    private List<TransferForPattern> currentTransfers;
    private int currentTargetStopPos;
    private int onTripEarliestBoardTime;
    private int onTripIndex;
    private TransferConstraint onTripTxConstraint;

    public ConstrainedBoardingSearch(boolean forwardSearch, TransferForPatternByStopPos transfers) {
        this.transfers = transfers;
        this.searchStrategy = forwardSearch ? FORWARD_STRATEGY : REVERSE_STRATEGY;
    }

    @Override
    public boolean transferExist(int targetStopPos) {
        if (this.transfers == null) {
            return false;
        }
        this.currentTransfers = this.transfers.get(targetStopPos);
        this.currentTargetStopPos = targetStopPos;
        return this.currentTransfers != null;
    }

    @Override
    public RaptorTripScheduleBoardOrAlightEvent<TripSchedule> find(RaptorTimeTable<TripSchedule> timetable, TripSchedule sourceTripSchedule, int sourceStopIndex, int prevTransitArrivalTime, int earliestBoardTime) {
        List<TransferForPattern> transfers = this.findMatchingTransfers(sourceTripSchedule, sourceStopIndex);
        if (transfers.isEmpty()) {
            return null;
        }
        boolean found = this.findTimetableTripInfo(timetable, transfers, this.currentTargetStopPos, prevTransitArrivalTime, earliestBoardTime);
        if (!found) {
            return null;
        }
        TripSchedule trip = timetable.getTripSchedule(this.onTripIndex);
        int departureTime = this.searchStrategy.time(trip, this.currentTargetStopPos);
        return new ConstrainedTransferBoarding<TripSchedule>(this.onTripTxConstraint, this.onTripIndex, trip, this.currentTargetStopPos, departureTime, this.onTripEarliestBoardTime);
    }

    private List<TransferForPattern> findMatchingTransfers(TripSchedule tripSchedule, int stopIndex) {
        Trip trip = tripSchedule.getOriginalTripTimes().getTrip();
        return this.currentTransfers.stream().filter(t -> t.matchesSourcePoint(stopIndex, trip)).collect(Collectors.toList());
    }

    public boolean findTimetableTripInfo(RaptorTimeTable<TripSchedule> timetable, List<TransferForPattern> transfers, int stopPos, int sourceTransitArrivalTime, int earliestBoardTime) {
        int nAllowedBoardings = 0;
        boolean useNextNormalTrip = false;
        IntIterator index = this.searchStrategy.scheduleIndexIterator(timetable);
        block0: while (index.hasNext()) {
            this.onTripIndex = index.next();
            TripSchedule it = timetable.getTripSchedule(this.onTripIndex);
            int time = this.searchStrategy.time(it, stopPos);
            if (this.searchStrategy.timeIsBefore(time, sourceTransitArrivalTime)) continue;
            ++nAllowedBoardings;
            Trip targetTrip = it.getOriginalTripTimes().getTrip();
            for (TransferForPattern tx : transfers) {
                this.onTripTxConstraint = (TransferConstraint)tx.getTransferConstraint();
                if (this.onTripTxConstraint.isFacilitated()) {
                    this.onTripEarliestBoardTime = sourceTransitArrivalTime;
                } else {
                    if (this.onTripTxConstraint.isMinTransferTimeSet()) {
                        int minTransferBoardTime = this.searchStrategy.plus(sourceTransitArrivalTime, this.onTripTxConstraint.getMinTransferTime());
                        this.onTripEarliestBoardTime = OTPFeature.MinimumTransferTimeIsDefinitive.isOn() ? minTransferBoardTime : this.searchStrategy.maxTime(earliestBoardTime, minTransferBoardTime);
                    } else {
                        this.onTripEarliestBoardTime = earliestBoardTime;
                    }
                    if (this.searchStrategy.timeIsBefore(time, this.onTripEarliestBoardTime)) continue;
                }
                if (tx.applyToAllTargetTrips()) {
                    return true;
                }
                if (!tx.applyToTargetTrip(targetTrip)) continue;
                if (this.onTripTxConstraint.isNotAllowed()) {
                    useNextNormalTrip = true;
                    continue block0;
                }
                return true;
            }
            if (useNextNormalTrip) {
                this.onTripEarliestBoardTime = earliestBoardTime;
                this.onTripTxConstraint = TransferConstraint.REGULAR_TRANSFER;
                return true;
            }
            if (nAllowedBoardings != 5) continue;
            return false;
        }
        return false;
    }
}

