/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.util.Objects;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedBoardingSearch;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPattern;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPatternByStopPos;
import org.opentripplanner.transit.raptor.api.transit.RaptorConstrainedTripScheduleBoardingSearch;

public class TripPatternWithRaptorStopIndexes {
    private final TripPattern pattern;
    private final int[] stopIndexes;
    private final TransferForPatternByStopPos constrainedTransfersForwardSearch = new TransferForPatternByStopPos();
    private final TransferForPatternByStopPos constrainedTransfersReverseSearch = new TransferForPatternByStopPos();
    private boolean sealedConstrainedTransfers = false;

    public TripPatternWithRaptorStopIndexes(TripPattern pattern, int[] stopIndexes) {
        this.pattern = pattern;
        this.stopIndexes = stopIndexes;
    }

    public FeedScopedId getId() {
        return this.pattern.getId();
    }

    public TransitMode getTransitMode() {
        return this.pattern.getMode();
    }

    public String getNetexSubmode() {
        return this.pattern.getNetexSubmode();
    }

    public int[] getStopIndexes() {
        return this.stopIndexes;
    }

    public final TripPattern getPattern() {
        return this.pattern;
    }

    public int stopIndex(int stopPositionInPattern) {
        return this.stopIndexes[stopPositionInPattern];
    }

    public RaptorConstrainedTripScheduleBoardingSearch<TripSchedule> constrainedTransferForwardSearch() {
        return new ConstrainedBoardingSearch(true, this.constrainedTransfersForwardSearch);
    }

    public RaptorConstrainedTripScheduleBoardingSearch<TripSchedule> constrainedTransferReverseSearch() {
        return new ConstrainedBoardingSearch(false, this.constrainedTransfersReverseSearch);
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TripPatternWithRaptorStopIndexes that = (TripPatternWithRaptorStopIndexes)o;
        return this.getId() == that.getId();
    }

    public String toString() {
        return "TripPattern{id=" + this.getId() + ", transitMode=" + this.pattern.getMode() + "}";
    }

    public void addTransferConstraintsForwardSearch(int targetStopPosition, TransferForPattern transferForPattern) {
        if (this.sealedConstrainedTransfers) {
            return;
        }
        this.constrainedTransfersForwardSearch.add(targetStopPosition, transferForPattern);
    }

    public void addTransferConstraintsReverseSearch(int targetStopPosition, TransferForPattern transferForPattern) {
        if (this.sealedConstrainedTransfers) {
            return;
        }
        this.constrainedTransfersReverseSearch.add(targetStopPosition, transferForPattern);
    }

    public void sealConstrainedTransfers() {
        if (this.sealedConstrainedTransfers) {
            return;
        }
        this.constrainedTransfersForwardSearch.sortOnSpecificityRanking();
        this.constrainedTransfersReverseSearch.sortOnSpecificityRanking();
        this.sealedConstrainedTransfers = true;
    }
}

