/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.time.Duration;
import java.util.List;
import org.opentripplanner.model.StopTransferPriority;
import org.opentripplanner.util.time.DurationUtils;

public interface TransitTuningParameters {
    public static final List<Duration> PAGING_SEARCH_WINDOW_ADJUSTMENTS = DurationUtils.durations("4h 2h 1h 30m 20m 10m");
    public static final TransitTuningParameters FOR_TEST = new TransitTuningParameters(){

        @Override
        public boolean enableStopTransferPriority() {
            return true;
        }

        @Override
        public Integer stopTransferCost(StopTransferPriority key) {
            switch (key) {
                case DISCOURAGED: {
                    return 3600;
                }
                case ALLOWED: {
                    return 60;
                }
                case RECOMMENDED: {
                    return 20;
                }
                case PREFERRED: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("Unknown key: " + key);
        }

        @Override
        public int transferCacheMaxSize() {
            return 5;
        }

        @Override
        public List<Duration> pagingSearchWindowAdjustments() {
            return PAGING_SEARCH_WINDOW_ADJUSTMENTS;
        }
    };

    public boolean enableStopTransferPriority();

    public Integer stopTransferCost(StopTransferPriority var1);

    public int transferCacheMaxSize();

    public List<Duration> pagingSearchWindowAdjustments();
}

