/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransferIndex;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.StopIndexForRaptor;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferIndexGenerator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TripPatternMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRequestTransferCache;
import org.opentripplanner.routing.api.request.RoutingRequest;

public class TransitLayer {
    private final HashMap<LocalDate, List<TripPatternForDate>> tripPatternsRunningOnDate;
    private final List<List<Transfer>> transfersByStopIndex;
    private final TransferService transferService;
    private final StopIndexForRaptor stopIndex;
    private final ZoneId transitDataZoneId;
    private final RaptorRequestTransferCache transferCache;
    private final TripPatternMapper tripPatternMapper;
    private final TransferIndexGenerator transferIndexGenerator;

    public TransitLayer(TransitLayer transitLayer) {
        this(transitLayer.tripPatternsRunningOnDate, transitLayer.transfersByStopIndex, transitLayer.transferService, transitLayer.stopIndex, transitLayer.transitDataZoneId, transitLayer.transferCache, transitLayer.tripPatternMapper, transitLayer.transferIndexGenerator);
    }

    public TransitLayer(Map<LocalDate, List<TripPatternForDate>> tripPatternsRunningOnDate, List<List<Transfer>> transfersByStopIndex, TransferService transferService, StopIndexForRaptor stopIndex, ZoneId transitDataZoneId, RaptorRequestTransferCache transferCache, TripPatternMapper tripPatternMapper, TransferIndexGenerator transferIndexGenerator) {
        this.tripPatternsRunningOnDate = new HashMap<LocalDate, List<TripPatternForDate>>(tripPatternsRunningOnDate);
        this.transfersByStopIndex = transfersByStopIndex;
        this.transferService = transferService;
        this.stopIndex = stopIndex;
        this.transitDataZoneId = transitDataZoneId;
        this.transferCache = transferCache;
        this.tripPatternMapper = tripPatternMapper;
        this.transferIndexGenerator = transferIndexGenerator;
    }

    public int getIndexByStop(Stop stop) {
        return this.stopIndex.indexOf(stop);
    }

    @Nullable
    public StopLocation getStopByIndex(int stop) {
        return stop == -1 ? null : this.stopIndex.stopByIndex(stop);
    }

    public StopIndexForRaptor getStopIndex() {
        return this.stopIndex;
    }

    public Collection<TripPatternForDate> getTripPatternsForDate(LocalDate date) {
        return this.tripPatternsRunningOnDate.getOrDefault(date, List.of());
    }

    public ZoneId getTransitDataZoneId() {
        return this.transitDataZoneId;
    }

    public int getStopCount() {
        return this.stopIndex.size();
    }

    @Nullable
    public List<TripPatternForDate> getTripPatternsRunningOnDateCopy(LocalDate runningPeriodDate) {
        List<TripPatternForDate> tripPatternForDate = this.tripPatternsRunningOnDate.get(runningPeriodDate);
        return tripPatternForDate != null ? new ArrayList<TripPatternForDate>(tripPatternForDate) : null;
    }

    @Nullable
    public List<TripPatternForDate> getTripPatternsStartingOnDateCopy(LocalDate date) {
        List<TripPatternForDate> tripPatternsRunningOnDate = this.getTripPatternsRunningOnDateCopy(date);
        return tripPatternsRunningOnDate != null ? tripPatternsRunningOnDate.stream().filter(t -> t.getLocalDate().equals(date)).collect(Collectors.toList()) : null;
    }

    public TransferService getTransferService() {
        return this.transferService;
    }

    public RaptorTransferIndex getRaptorTransfersForRequest(RoutingRequest routingRequest) {
        return this.transferCache.get(this.transfersByStopIndex, routingRequest);
    }

    public RaptorRequestTransferCache getTransferCache() {
        return this.transferCache;
    }

    public TripPatternMapper getTripPatternMapper() {
        return this.tripPatternMapper;
    }

    public TransferIndexGenerator getTransferIndexGenerator() {
        return this.transferIndexGenerator;
    }

    public void replaceTripPatternsForDate(LocalDate date, List<TripPatternForDate> tripPatternForDates) {
        this.tripPatternsRunningOnDate.replace(date, tripPatternForDates);
    }
}

