/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransferWithDuration;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;

public class Transfer {
    private final int toStop;
    private final int distanceMeters;
    private final List<Edge> edges;

    public Transfer(int toStop, List<Edge> edges) {
        this.toStop = toStop;
        this.edges = edges;
        this.distanceMeters = (int)edges.stream().mapToDouble(Edge::getDistanceMeters).sum();
    }

    public Transfer(int toStopIndex, int distanceMeters) {
        this.toStop = toStopIndex;
        this.distanceMeters = distanceMeters;
        this.edges = null;
    }

    public List<Coordinate> getCoordinates() {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        if (this.edges == null) {
            return coordinates;
        }
        for (Edge edge : this.edges) {
            if (edge.getGeometry() == null) continue;
            coordinates.addAll(Arrays.asList(edge.getGeometry().getCoordinates()));
        }
        return coordinates;
    }

    public int getToStop() {
        return this.toStop;
    }

    public int getDistanceMeters() {
        return this.distanceMeters;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public Optional<RaptorTransfer> asRaptorTransfer(RoutingRequest routingRequest) {
        if (this.edges == null || this.edges.isEmpty()) {
            double durationSeconds = (double)this.distanceMeters / routingRequest.walkSpeed;
            return Optional.of(new TransferWithDuration(this, (int)Math.ceil(durationSeconds), RaptorCostConverter.toRaptorCost(durationSeconds * routingRequest.walkReluctance)));
        }
        StateEditor se = new StateEditor(routingRequest, this.edges.get(0).getFromVertex());
        se.setTimeSeconds(0L);
        State s = se.makeState();
        for (Edge e : this.edges) {
            s = e.traverse(s);
            if (s != null) continue;
            return Optional.empty();
        }
        return Optional.of(new TransferWithDuration(this, (int)s.getElapsedTimeSeconds(), RaptorCostConverter.toRaptorCost(s.getWeight())));
    }

    public static RoutingRequest prepareTransferRoutingRequest(RoutingRequest request) {
        RoutingRequest transferRoutingRequest = request.getStreetSearchRequest(request.modes.transferMode);
        transferRoutingRequest.arriveBy = false;
        transferRoutingRequest.setDateTime(Instant.ofEpochSecond(0L));
        transferRoutingRequest.from = null;
        transferRoutingRequest.to = null;
        transferRoutingRequest.bikeTriangleSafetyFactor = Transfer.roundTo(request.bikeTriangleSafetyFactor, 1);
        transferRoutingRequest.bikeTriangleSlopeFactor = Transfer.roundTo(request.bikeTriangleSlopeFactor, 1);
        transferRoutingRequest.bikeTriangleTimeFactor = 1.0 - transferRoutingRequest.bikeTriangleSafetyFactor - transferRoutingRequest.bikeTriangleSlopeFactor;
        transferRoutingRequest.bikeSwitchCost = Transfer.roundTo100(request.bikeSwitchCost);
        transferRoutingRequest.bikeSwitchTime = Transfer.roundTo100(request.bikeSwitchTime);
        transferRoutingRequest.wheelchairAccessible = request.wheelchairAccessible;
        transferRoutingRequest.maxWheelchairSlope = request.maxWheelchairSlope;
        transferRoutingRequest.walkSpeed = Transfer.roundToHalf(request.walkSpeed);
        transferRoutingRequest.bikeSpeed = Transfer.roundToHalf(request.bikeSpeed);
        transferRoutingRequest.walkReluctance = Transfer.roundTo(request.walkReluctance, 1);
        transferRoutingRequest.stairsReluctance = Transfer.roundTo(request.stairsReluctance, 1);
        transferRoutingRequest.stairsTimeFactor = Transfer.roundTo(request.stairsTimeFactor, 1);
        transferRoutingRequest.turnReluctance = Transfer.roundTo(request.turnReluctance, 1);
        transferRoutingRequest.elevatorBoardCost = Transfer.roundTo100(request.elevatorBoardCost);
        transferRoutingRequest.elevatorBoardTime = Transfer.roundTo100(request.elevatorBoardTime);
        transferRoutingRequest.elevatorHopCost = Transfer.roundTo100(request.elevatorHopCost);
        transferRoutingRequest.elevatorHopTime = Transfer.roundTo100(request.elevatorHopTime);
        return transferRoutingRequest;
    }

    private static double roundToHalf(double input) {
        return (double)((int)(input * 2.0 + 0.5)) / 2.0;
    }

    private static double roundTo(double input, int decimals) {
        return (double)Math.round(input * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }

    private static int roundTo100(int input) {
        if (input > 0 && input < 100) {
            return 100;
        }
        return (input + 50) / 100 * 100;
    }
}

