/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTransferPriority;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;

public final class StopIndexForRaptor {
    private final List<StopLocation> stopsByIndex;
    private final Map<StopLocation, Integer> indexByStop = new HashMap<StopLocation, Integer>();
    public final int[] stopBoardAlightCosts;

    public StopIndexForRaptor(Collection<StopLocation> stops, TransitTuningParameters tuningParameters) {
        this.stopsByIndex = List.copyOf(stops);
        this.initializeIndexByStop();
        this.stopBoardAlightCosts = StopIndexForRaptor.createStopBoardAlightCosts(this.stopsByIndex, tuningParameters);
    }

    public StopLocation stopByIndex(int index) {
        return this.stopsByIndex.get(index);
    }

    public int indexOf(StopLocation stop) {
        return this.indexByStop.get(stop);
    }

    public int size() {
        return this.stopsByIndex.size();
    }

    public int[] listStopIndexesForStops(List<StopLocation> stops) {
        int[] stopIndex = new int[stops.size()];
        for (int i = 0; i < stops.size(); ++i) {
            stopIndex[i] = this.indexByStop.get(stops.get(i));
        }
        return stopIndex;
    }

    public int[] listStopIndexesForPattern(TripPattern pattern) {
        int[] stopIndex = new int[pattern.numberOfStops()];
        for (int i = 0; i < pattern.numberOfStops(); ++i) {
            stopIndex[i] = this.indexByStop.get(pattern.getStop(i));
        }
        return stopIndex;
    }

    private void initializeIndexByStop() {
        for (int i = 0; i < this.stopsByIndex.size(); ++i) {
            this.indexByStop.put(this.stopsByIndex.get(i), i);
        }
    }

    private static int[] createStopBoardAlightCosts(List<StopLocation> stops, TransitTuningParameters tuningParams) {
        if (!tuningParams.enableStopTransferPriority()) {
            return null;
        }
        int[] stopVisitCosts = new int[stops.size()];
        for (int i = 0; i < stops.size(); ++i) {
            StopTransferPriority priority = stops.get(i).getPriority();
            int domainCost = tuningParams.stopTransferCost(priority);
            stopVisitCosts[i] = RaptorCostConverter.toRaptorCost(domainCost);
        }
        return stopVisitCosts;
    }
}

