/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.util.Map;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;
import org.opentripplanner.transit.raptor.api.transit.RaptorSlackProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripPattern;

public final class SlackProvider
implements RaptorSlackProvider {
    private final int[] boardSlack;
    private final int[] alightSlack;
    private final int transferSlack;

    public SlackProvider(int transferSlack, int defaultBoardSlack, Map<TransitMode, Integer> modeBoardSlack, int defaultAlightSlack, Map<TransitMode, Integer> modeAlightSlack) {
        this.transferSlack = transferSlack;
        this.boardSlack = SlackProvider.slackByMode(modeBoardSlack, defaultBoardSlack);
        this.alightSlack = SlackProvider.slackByMode(modeAlightSlack, defaultAlightSlack);
    }

    @Override
    public int boardSlack(RaptorTripPattern pattern) {
        return this.boardSlack[SlackProvider.index(pattern)];
    }

    @Override
    public int alightSlack(RaptorTripPattern pattern) {
        return this.alightSlack[SlackProvider.index(pattern)];
    }

    @Override
    public int transferSlack() {
        return this.transferSlack;
    }

    private static int[] slackByMode(Map<TransitMode, Integer> modeSlack, int defaultSlack) {
        int[] result = new int[TransitMode.values().length];
        for (TransitMode mode : TransitMode.values()) {
            result[SlackProvider.index((TransitMode)mode)] = modeSlack.getOrDefault((Object)mode, defaultSlack);
        }
        return result;
    }

    private static int index(RaptorTripPattern pattern) {
        return SlackProvider.index(((TripPatternForDates)pattern).getTripPattern().getTransitMode());
    }

    private static int index(TransitMode mode) {
        return mode.ordinal();
    }
}

