/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.util.ReversedRaptorTransfer;

public class RaptorTransferIndex {
    private final List<List<RaptorTransfer>> forwardTransfers;
    private final List<List<RaptorTransfer>> reversedTransfers;

    public RaptorTransferIndex(List<List<RaptorTransfer>> forwardTransfers, List<List<RaptorTransfer>> reversedTransfers) {
        this.forwardTransfers = forwardTransfers;
        this.reversedTransfers = reversedTransfers;
    }

    public List<List<RaptorTransfer>> getForwardTransfers() {
        return this.forwardTransfers;
    }

    public List<List<RaptorTransfer>> getReversedTransfers() {
        return this.reversedTransfers;
    }

    public static RaptorTransferIndex create(List<List<Transfer>> transfersByStopIndex, RoutingRequest routingRequest) {
        ArrayList<List<RaptorTransfer>> forwardTransfers = new ArrayList<List<RaptorTransfer>>(transfersByStopIndex.size());
        ArrayList<List<RaptorTransfer>> reversedTransfers = new ArrayList<List<RaptorTransfer>>(transfersByStopIndex.size());
        for (int i = 0; i < transfersByStopIndex.size(); ++i) {
            forwardTransfers.add(new ArrayList());
            reversedTransfers.add(new ArrayList());
        }
        for (int fromStop = 0; fromStop < transfersByStopIndex.size(); ++fromStop) {
            Collection transfers = transfersByStopIndex.get(fromStop).stream().flatMap(s -> s.asRaptorTransfer(routingRequest).stream()).collect(Collectors.toMap(RaptorTransfer::stop, Function.identity(), (a, b) -> a.generalizedCost() < b.generalizedCost() ? a : b)).values();
            forwardTransfers.get(fromStop).addAll(transfers);
            for (RaptorTransfer forwardTransfer : transfers) {
                reversedTransfers.get(forwardTransfer.stop()).add(new ReversedRaptorTransfer(fromStop, forwardTransfer));
            }
        }
        return new RaptorTransferIndex(forwardTransfers, reversedTransfers);
    }
}

