/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;

public class AccessEgress
implements RaptorTransfer {
    private int toFromStop;
    private final int durationInSeconds;
    private final int generalizedCost;
    private final State lastState;

    public AccessEgress(int toFromStop, State lastState) {
        this.toFromStop = toFromStop;
        this.durationInSeconds = (int)lastState.getElapsedTimeSeconds();
        this.generalizedCost = RaptorCostConverter.toRaptorCost(lastState.getWeight());
        this.lastState = lastState;
    }

    @Override
    public int stop() {
        return this.toFromStop;
    }

    @Override
    public int generalizedCost() {
        return this.generalizedCost;
    }

    @Override
    public int durationInSeconds() {
        return this.durationInSeconds;
    }

    @Override
    public boolean hasOpeningHours() {
        return false;
    }

    public State getLastState() {
        return this.lastState;
    }

    public String toString() {
        return ToStringBuilder.of(AccessEgress.class).addStr("transfer", this.asString()).addObj("state", this.lastState).toString();
    }
}

