/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router.street;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opentripplanner.graph_builder.module.NearbyStopFinder;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessEgressRouter {
    private static final Logger LOG = LoggerFactory.getLogger(AccessEgressRouter.class);

    private AccessEgressRouter() {
    }

    public static Collection<NearbyStop> streetSearch(RoutingRequest rr, StreetMode streetMode, boolean fromTarget) {
        Set<Vertex> vertices = fromTarget ^ rr.arriveBy ? rr.rctx.toVertices : rr.rctx.fromVertices;
        RoutingRequest nearbyRequest = rr.getStreetSearchRequest(streetMode);
        NearbyStopFinder nearbyStopFinder = new NearbyStopFinder(rr.rctx.graph, rr.getMaxAccessEgressDurationSecondsForMode(streetMode), true);
        List<NearbyStop> nearbyStopList = nearbyStopFinder.findNearbyStopsViaStreets(vertices, fromTarget, true, nearbyRequest);
        LOG.debug("Found {} {} stops", (Object)nearbyStopList.size(), (Object)(fromTarget ? "egress" : "access"));
        return nearbyStopList;
    }
}

