/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.opentripplanner.ext.flex.FlexAccessEgress;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.mapping.RaptorPathToItineraryMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.router.AccessEgresses;
import org.opentripplanner.routing.algorithm.raptoradapter.router.AdditionalSearchDays;
import org.opentripplanner.routing.algorithm.raptoradapter.router.TransitRouterResult;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.AccessEgressRouter;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.FlexAccessEgressRouter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.AccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.AccessEgressMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.RaptorRequestMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRoutingRequestTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RoutingRequestTransitDataProviderFilter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransitDataProviderFilter;
import org.opentripplanner.routing.algorithm.transferoptimization.configure.TransferOptimizationServiceConfigurator;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.framework.DebugTimingAggregator;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.GraphIndex;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.standalone.server.Router;
import org.opentripplanner.transit.raptor.RaptorService;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.response.RaptorResponse;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitRouter {
    private static final Logger LOG = LoggerFactory.getLogger(TransitRouter.class);
    public static final int NOT_SET = -1;
    private final RoutingRequest request;
    private final Router router;
    private final DebugTimingAggregator debugTimingAggregator;
    private final ZonedDateTime transitSearchTimeZero;
    private final AdditionalSearchDays additionalSearchDays;

    private TransitRouter(RoutingRequest request, Router router, ZonedDateTime transitSearchTimeZero, AdditionalSearchDays additionalSearchDays, DebugTimingAggregator debugTimingAggregator) {
        this.request = request;
        this.router = router;
        this.transitSearchTimeZero = transitSearchTimeZero;
        this.additionalSearchDays = additionalSearchDays;
        this.debugTimingAggregator = debugTimingAggregator;
    }

    private TransitRouterResult route() {
        if (this.request.modes.transitModes.isEmpty()) {
            return new TransitRouterResult(List.of(), null);
        }
        if (!this.router.graph.transitFeedCovers(this.request.getDateTime())) {
            throw new RoutingValidationException(List.of(new RoutingError(RoutingErrorCode.OUTSIDE_SERVICE_PERIOD, InputField.DATE_TIME)));
        }
        TransitLayer transitLayer = this.request.ignoreRealtimeUpdates ? this.router.graph.getTransitLayer() : this.router.graph.getRealtimeTransitLayer();
        RaptorRoutingRequestTransitData requestTransitDataProvider = this.createRequestTransitDataProvider(transitLayer);
        this.debugTimingAggregator.finishedPatternFiltering();
        AccessEgresses accessEgresses = this.getAccessEgresses(transitLayer);
        this.debugTimingAggregator.finishedAccessEgress(accessEgresses.getAccesses().size(), accessEgresses.getEgresses().size());
        ArrayList<Itinerary> itineraries = new ArrayList<Itinerary>();
        RaptorRequest<TripSchedule> raptorRequest = RaptorRequestMapper.mapRequest(this.request, this.transitSearchTimeZero, accessEgresses.getAccesses(), accessEgresses.getEgresses());
        RaptorResponse<TripSchedule> transitResponse = new RaptorService<TripSchedule>(this.router.raptorConfig).route(raptorRequest, requestTransitDataProvider);
        this.checkIfTransitConnectionExists(transitResponse);
        this.debugTimingAggregator.finishedRaptorSearch();
        Collection<Path<TripSchedule>> paths = transitResponse.paths();
        if (OTPFeature.OptimizeTransfers.isOn()) {
            paths = TransferOptimizationServiceConfigurator.createOptimizeTransferService(transitLayer::getStopByIndex, requestTransitDataProvider.stopNameResolver(), this.router.graph.getTransferService(), requestTransitDataProvider, transitLayer.getStopIndex().stopBoardAlightCosts, raptorRequest, this.request.transferOptimization).optimize(transitResponse.paths());
        }
        RaptorPathToItineraryMapper itineraryMapper = new RaptorPathToItineraryMapper(this.router.graph, transitLayer, this.transitSearchTimeZero, this.request);
        FareService fareService = this.router.graph.getService(FareService.class);
        for (Path<TripSchedule> path : paths) {
            Itinerary itinerary = itineraryMapper.createItinerary(path);
            if (fareService != null) {
                itinerary.fare = fareService.getCost(itinerary);
            }
            itineraries.add(itinerary);
        }
        this.debugTimingAggregator.finishedItineraryCreation();
        return new TransitRouterResult(itineraries, transitResponse.requestUsed().searchParams());
    }

    private AccessEgresses getAccessEgresses(TransitLayer transitLayer) {
        AccessEgressMapper accessEgressMapper = new AccessEgressMapper(transitLayer.getStopIndex());
        ArrayList<AccessEgress> accessList = new ArrayList<AccessEgress>();
        ArrayList<AccessEgress> egressList = new ArrayList<AccessEgress>();
        Runnable accessCalculator = () -> {
            this.debugTimingAggregator.startedAccessCalculating();
            accessList.addAll(this.getAccessEgresses(accessEgressMapper, false));
            this.debugTimingAggregator.finishedAccessCalculating();
        };
        Runnable egressCalculator = () -> {
            this.debugTimingAggregator.startedEgressCalculating();
            egressList.addAll(this.getAccessEgresses(accessEgressMapper, true));
            this.debugTimingAggregator.finishedEgressCalculating();
        };
        if (OTPFeature.ParallelRouting.isOn()) {
            try {
                CompletableFuture.allOf(CompletableFuture.runAsync(accessCalculator), CompletableFuture.runAsync(egressCalculator)).join();
            }
            catch (CompletionException e) {
                RoutingValidationException.unwrapAndRethrowCompletionException(e);
            }
        } else {
            accessCalculator.run();
            egressCalculator.run();
        }
        this.verifyAccessEgress(accessList, egressList);
        return new AccessEgresses(accessList, egressList);
    }

    private Collection<AccessEgress> getAccessEgresses(AccessEgressMapper accessEgressMapper, boolean isEgress) {
        ArrayList<AccessEgress> results = new ArrayList<AccessEgress>();
        StreetMode mode = isEgress ? this.request.modes.egressMode : this.request.modes.accessMode;
        try (RoutingRequest accessRequest = this.request.getStreetSearchRequest(mode);){
            accessRequest.setRoutingContext(this.router.graph);
            if (!isEgress) {
                accessRequest.allowKeepingRentedVehicleAtDestination = false;
            }
            Collection<NearbyStop> nearbyStops = AccessEgressRouter.streetSearch(accessRequest, mode, isEgress);
            results.addAll(accessEgressMapper.mapNearbyStops(nearbyStops, isEgress));
            if (OTPFeature.FlexRouting.isOn() && mode == StreetMode.FLEXIBLE) {
                Collection<FlexAccessEgress> flexAccessList = FlexAccessEgressRouter.routeAccessEgress(accessRequest, this.additionalSearchDays, this.router.routerConfig.flexParameters(this.request), isEgress);
                results.addAll(accessEgressMapper.mapFlexAccessEgresses(flexAccessList, isEgress));
            }
        }
        return results;
    }

    private RaptorRoutingRequestTransitData createRequestTransitDataProvider(TransitLayer transitLayer) {
        Graph graph = this.router.graph;
        try (RoutingRequest transferRoutingRequest = Transfer.prepareTransferRoutingRequest(this.request);){
            transferRoutingRequest.setRoutingContext(graph, (Vertex)null, null);
            RaptorRoutingRequestTransitData raptorRoutingRequestTransitData = new RaptorRoutingRequestTransitData(graph.getTransferService(), transitLayer, this.transitSearchTimeZero, this.additionalSearchDays.additionalSearchDaysInPast(), this.additionalSearchDays.additionalSearchDaysInFuture(), this.createRequestTransitDataProviderFilter(graph.index), transferRoutingRequest);
            return raptorRoutingRequestTransitData;
        }
    }

    private TransitDataProviderFilter createRequestTransitDataProviderFilter(GraphIndex graphIndex) {
        return new RoutingRequestTransitDataProviderFilter(this.request, graphIndex);
    }

    private void verifyAccessEgress(Collection<?> access, Collection<?> egress) {
        boolean egressExist;
        boolean accessExist = !access.isEmpty();
        boolean bl = egressExist = !egress.isEmpty();
        if (accessExist && egressExist) {
            return;
        }
        ArrayList<RoutingError> routingErrors = new ArrayList<RoutingError>();
        if (!accessExist) {
            routingErrors.add(new RoutingError(RoutingErrorCode.NO_STOPS_IN_RANGE, InputField.FROM_PLACE));
        }
        if (!egressExist) {
            routingErrors.add(new RoutingError(RoutingErrorCode.NO_STOPS_IN_RANGE, InputField.TO_PLACE));
        }
        throw new RoutingValidationException(routingErrors);
    }

    private void checkIfTransitConnectionExists(RaptorResponse<TripSchedule> response) {
        int searchWindowUsed = response.requestUsed().searchParams().searchWindowInSeconds();
        if (searchWindowUsed <= 0 && response.paths().isEmpty()) {
            throw new RoutingValidationException(List.of(new RoutingError(RoutingErrorCode.NO_TRANSIT_CONNECTION, null)));
        }
    }

    public static TransitRouterResult route(RoutingRequest request, Router router, ZonedDateTime transitSearchTimeZero, AdditionalSearchDays additionalSearchDays, DebugTimingAggregator debugTimingAggregator) {
        return new TransitRouter(request, router, transitSearchTimeZero, additionalSearchDays, debugTimingAggregator).route();
    }
}

