/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router;

import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Optional;

public class AdditionalSearchDays {
    private final boolean arriveBy;
    private final ZonedDateTime searchDateTime;
    private final Optional<Duration> searchWindow;
    private final Duration maxSearchWindow;
    private final Duration maxJourneyDuration;

    public AdditionalSearchDays(boolean arriveBy, ZonedDateTime searchDateTime, Duration searchWindow, Duration maxSearchWindow, Duration maxJourneyDuration) {
        this.arriveBy = arriveBy;
        this.searchDateTime = searchDateTime;
        this.searchWindow = Optional.ofNullable(searchWindow);
        this.maxSearchWindow = maxSearchWindow;
        this.maxJourneyDuration = maxJourneyDuration;
    }

    public int additionalSearchDaysInPast() {
        if (this.arriveBy) {
            Duration sw = this.getMaximumSearchWindow();
            ZonedDateTime earliestStart = this.searchDateTime.minus(this.maxJourneyDuration.plus(sw));
            return this.daysInBetween(this.searchDateTime, earliestStart);
        }
        return 0;
    }

    public int additionalSearchDaysInFuture() {
        if (this.arriveBy) {
            return 0;
        }
        Duration sw = this.getMaximumSearchWindow();
        ZonedDateTime requestTime = this.searchDateTime;
        ZonedDateTime lastArrival = requestTime.plus(this.maxJourneyDuration.plus(sw));
        return this.daysInBetween(requestTime, lastArrival);
    }

    private Duration getMaximumSearchWindow() {
        return this.searchWindow.orElse(this.maxSearchWindow);
    }

    private int daysInBetween(ZonedDateTime requestTime, ZonedDateTime earliestStart) {
        return Math.abs(Period.between(requestTime.toLocalDate(), earliestStart.toLocalDate()).getDays());
    }

    public static AdditionalSearchDays defaults(ZonedDateTime time) {
        return new AdditionalSearchDays(false, time, Duration.ofHours(6L), Duration.ofDays(1L), Duration.ofDays(1L));
    }
}

