/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.DirectionUtils;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.model.VehicleRentalStationInfo;
import org.opentripplanner.model.WgsCoordinate;
import org.opentripplanner.model.plan.RelativeDirection;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.routing.algorithm.mapping.GraphPathToItineraryMapper;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.edgetype.AreaEdge;
import org.opentripplanner.routing.edgetype.ElevatorAlightEdge;
import org.opentripplanner.routing.edgetype.FreeEdge;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.ExitVertex;
import org.opentripplanner.routing.vertextype.VehicleRentalStationVertex;

public class StatesToWalkStepsMapper {
    private static final double MAX_ZAG_DISTANCE = 30.0;
    private final Graph graph;
    private final List<State> states;
    private final WalkStep previous;
    private final List<WalkStep> steps = new ArrayList<WalkStep>();
    private WalkStep current = null;
    private double lastAngle = 0.0;
    private double distance = 0.0;
    private int roundaboutExit = 0;
    private String roundaboutPreviousStreet = null;

    public StatesToWalkStepsMapper(Graph graph, List<State> states, WalkStep previousStep) {
        this.graph = graph;
        this.states = states;
        this.previous = previousStep;
    }

    public List<WalkStep> generateWalkSteps() {
        for (int i = 0; i < this.states.size() - 1; ++i) {
            this.processState(this.states.get(i), this.states.get(i + 1));
        }
        if (this.steps.isEmpty()) {
            return this.steps;
        }
        if (GraphPathToItineraryMapper.isRentalPickUp(this.states.get(this.states.size() - 1))) {
            VehicleRentalStationVertex vertex = (VehicleRentalStationVertex)this.states.get(this.states.size() - 1).getVertex();
            this.steps.get((int)(this.steps.size() - 1)).vehicleRentalOnStation = new VehicleRentalStationInfo(vertex);
        }
        if (GraphPathToItineraryMapper.isRentalDropOff(this.states.get(0))) {
            VehicleRentalStationVertex vertex = (VehicleRentalStationVertex)this.states.get(0).getVertex();
            this.steps.get((int)0).vehicleRentalOffStation = new VehicleRentalStationInfo(vertex);
        }
        return this.steps;
    }

    private void processState(State backState, State forwardState) {
        double thisAngle;
        boolean modeTransition;
        Edge edge = forwardState.getBackEdge();
        boolean createdNewStep = false;
        if (edge instanceof FreeEdge) {
            return;
        }
        if (forwardState.getBackMode() == null) {
            return;
        }
        LineString geom = edge.getGeometry();
        if (geom == null) {
            return;
        }
        if (edge instanceof ElevatorAlightEdge) {
            this.createElevatorWalkStep(backState, forwardState, edge);
            return;
        }
        String streetName = edge.getName().toString();
        String streetNameNoParens = StatesToWalkStepsMapper.getNormalizedName(streetName);
        boolean bl = modeTransition = forwardState.getBackMode() != backState.getBackMode();
        if (this.current == null) {
            this.createFirstStep(backState, forwardState);
            createdNewStep = true;
        } else if (modeTransition || !this.continueOnSameStreet(edge, streetNameNoParens) || edge.isRoundabout() != this.roundaboutExit > 0 || StatesToWalkStepsMapper.isLink(edge) && !StatesToWalkStepsMapper.isLink(backState.getBackEdge())) {
            if (this.roundaboutExit > 0) {
                this.current.exit = Integer.toString(this.roundaboutExit);
                if (streetNameNoParens.equals(this.roundaboutPreviousStreet)) {
                    this.current.stayOn = true;
                }
                this.roundaboutExit = 0;
            }
            this.current = StatesToWalkStepsMapper.createWalkStep(this.graph, forwardState, backState);
            createdNewStep = true;
            this.steps.add(this.current);
            if (edge.isRoundabout()) {
                this.roundaboutExit = 1;
                this.roundaboutPreviousStreet = StatesToWalkStepsMapper.getNormalizedName(backState.getBackEdge().getName().toString());
            }
            thisAngle = DirectionUtils.getFirstAngle((Geometry)geom);
            this.current.setDirections(this.lastAngle, thisAngle, edge.isRoundabout());
            this.distance = edge.getDistanceMeters();
        } else {
            thisAngle = DirectionUtils.getFirstAngle((Geometry)geom);
            RelativeDirection direction = WalkStep.getRelativeDirection(this.lastAngle, thisAngle, edge.isRoundabout());
            boolean optionsBefore = backState.multipleOptionsBefore();
            if (edge.isRoundabout()) {
                if (optionsBefore) {
                    ++this.roundaboutExit;
                }
            } else if (direction != RelativeDirection.CONTINUE && this.isPossibleToTurnToOtherStreet(backState, edge, streetName, thisAngle)) {
                this.current = StatesToWalkStepsMapper.createWalkStep(this.graph, forwardState, backState);
                createdNewStep = true;
                this.steps.add(this.current);
                this.current.setDirections(this.lastAngle, thisAngle, false);
                this.current.stayOn = true;
                this.distance = edge.getDistanceMeters();
            }
        }
        this.setMotorwayExit(backState);
        if (createdNewStep && !modeTransition) {
            int lastIndex = this.steps.size() - 1;
            if (lastIndex >= 2) {
                WalkStep threeBack = this.steps.get(lastIndex - 2);
                WalkStep twoBack = this.steps.get(lastIndex - 1);
                WalkStep lastStep = this.steps.get(lastIndex);
                boolean isOnSameStreet = lastStep.streetNameNoParens().equals(threeBack.streetNameNoParens());
                if (twoBack.distance < 30.0 && isOnSameStreet) {
                    if (StatesToWalkStepsMapper.isUTurn(twoBack, lastStep)) {
                        this.steps.remove(lastIndex - 1);
                        this.processUTurn(lastStep, twoBack);
                    } else {
                        this.steps.remove(lastIndex);
                        this.steps.remove(lastIndex - 1);
                        this.removeZag(threeBack, twoBack);
                    }
                }
            }
        } else {
            if (!createdNewStep && this.current.elevation != null) {
                this.updateElevationProfile(backState, edge);
            }
            this.distance += edge.getDistanceMeters();
        }
        this.current.distance += edge.getDistanceMeters();
        this.current.addStreetNotes(this.graph.streetNotesService.getNotes(forwardState));
        this.lastAngle = DirectionUtils.getLastAngle((Geometry)geom);
        this.current.edges.add(edge);
    }

    private void updateElevationProfile(State backState, Edge edge) {
        List<P2<Double>> s = StatesToWalkStepsMapper.encodeElevationProfile(edge, this.distance, backState.getOptions().geoidElevation ? -this.graph.ellipsoidToGeoidDifference.doubleValue() : 0.0);
        if (this.current.elevation != null && this.current.elevation.size() > 0) {
            this.current.elevation.addAll(s);
        } else {
            this.current.elevation = s;
        }
    }

    private void removeZag(WalkStep threeBack, WalkStep twoBack) {
        this.current = threeBack;
        this.current.distance += twoBack.distance;
        this.distance += this.current.distance;
        if (twoBack.elevation != null) {
            if (this.current.elevation == null) {
                this.current.elevation = twoBack.elevation;
            } else {
                for (P2<Double> d : twoBack.elevation) {
                    this.current.elevation.add(new P2<Double>((Double)d.first + this.current.distance, (Double)d.second));
                }
            }
        }
    }

    private static boolean isUTurn(WalkStep twoBack, WalkStep lastStep) {
        RelativeDirection d1 = lastStep.relativeDirection;
        RelativeDirection d2 = twoBack.relativeDirection;
        return !((d1 != RelativeDirection.RIGHT && d1 != RelativeDirection.HARD_RIGHT || d2 != RelativeDirection.RIGHT && d2 != RelativeDirection.HARD_RIGHT) && (d1 != RelativeDirection.LEFT && d1 != RelativeDirection.HARD_LEFT || d2 != RelativeDirection.LEFT && d2 != RelativeDirection.HARD_LEFT));
    }

    private void processUTurn(WalkStep lastStep, WalkStep twoBack) {
        lastStep.distance += twoBack.distance;
        lastStep.relativeDirection = lastStep.relativeDirection == RelativeDirection.LEFT || lastStep.relativeDirection == RelativeDirection.HARD_LEFT ? RelativeDirection.UTURN_LEFT : RelativeDirection.UTURN_RIGHT;
        lastStep.stayOn = true;
    }

    private void setMotorwayExit(State backState) {
        State exitState = backState;
        Edge exitEdge = exitState.getBackEdge();
        while (exitEdge instanceof FreeEdge) {
            exitState = exitState.getBackState();
            exitEdge = exitState.getBackEdge();
        }
        if (exitState.getVertex() instanceof ExitVertex) {
            this.current.exit = ((ExitVertex)exitState.getVertex()).getExitName();
        }
    }

    private boolean isPossibleToTurnToOtherStreet(State backState, Edge edge, String streetName, double thisAngle) {
        if (edge instanceof StreetEdge) {
            double angleDiff = StatesToWalkStepsMapper.getAbsoluteAngleDiff(thisAngle, this.lastAngle);
            for (Edge alternative : backState.getVertex().getOutgoingStreetEdges()) {
                if (!this.isTurnToOtherStreet(streetName, angleDiff, alternative)) continue;
                return true;
            }
        } else {
            double angleDiff = StatesToWalkStepsMapper.getAbsoluteAngleDiff(this.lastAngle, thisAngle);
            State twoStatesBack = backState.getBackState();
            Vertex backVertex = twoStatesBack.getVertex();
            for (Edge alternative : backVertex.getOutgoingStreetEdges()) {
                for (Edge innerAlternative : alternative.getToVertex().getOutgoingStreetEdges()) {
                    if (!this.isTurnToOtherStreet(streetName, angleDiff, innerAlternative)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isTurnToOtherStreet(String streetName, double angleDiff, Edge alternative) {
        if (alternative.getName().toString().equals(streetName)) {
            return false;
        }
        double altAngle = DirectionUtils.getFirstAngle((Geometry)alternative.getGeometry());
        double altAngleDiff = StatesToWalkStepsMapper.getAbsoluteAngleDiff(altAngle, this.lastAngle);
        return angleDiff > 0.7853981633974483 || altAngleDiff - angleDiff < 0.19634954084936207;
    }

    private boolean continueOnSameStreet(Edge edge, String streetNameNoParens) {
        return this.current.streetName == null || this.current.streetNameNoParens().equals(streetNameNoParens) || this.current.bogusName != false && edge.hasBogusName();
    }

    private void createFirstStep(State backState, State forwardState) {
        this.current = StatesToWalkStepsMapper.createWalkStep(this.graph, forwardState, backState);
        this.steps.add(this.current);
        Edge edge = forwardState.getBackEdge();
        double thisAngle = DirectionUtils.getFirstAngle((Geometry)edge.getGeometry());
        if (this.previous == null) {
            this.current.setAbsoluteDirection(thisAngle);
            this.current.relativeDirection = RelativeDirection.DEPART;
        } else {
            this.current.setDirections(this.previous.angle, thisAngle, false);
        }
        this.distance = edge.getDistanceMeters();
    }

    private void createElevatorWalkStep(State backState, State forwardState, Edge edge) {
        this.current = StatesToWalkStepsMapper.createWalkStep(this.graph, forwardState, backState);
        this.current.streetName = edge.getName();
        this.current.relativeDirection = RelativeDirection.ELEVATOR;
        this.steps.add(this.current);
    }

    private static WalkStep createWalkStep(Graph graph, State forwardState, State backState) {
        Edge en = forwardState.getBackEdge();
        WalkStep step = new WalkStep();
        step.streetName = en.getName();
        step.startLocation = new WgsCoordinate(backState.getVertex().getLat(), backState.getVertex().getLon());
        step.elevation = StatesToWalkStepsMapper.encodeElevationProfile(forwardState.getBackEdge(), 0.0, forwardState.getOptions().geoidElevation ? -graph.ellipsoidToGeoidDifference.doubleValue() : 0.0);
        step.bogusName = en.hasBogusName();
        step.addStreetNotes(graph.streetNotesService.getNotes(forwardState));
        step.angle = DirectionUtils.getFirstAngle((Geometry)forwardState.getBackEdge().getGeometry());
        step.walkingBike = forwardState.isBackWalkingBike();
        if (forwardState.getBackEdge() instanceof AreaEdge) {
            step.area = true;
        }
        return step;
    }

    private static String getNormalizedName(String streetName) {
        int idx = streetName.indexOf(40);
        if (idx > 0) {
            return streetName.substring(0, idx - 1);
        }
        return streetName;
    }

    private static double getAbsoluteAngleDiff(double thisAngle, double lastAngle) {
        double ccwAngleDiff;
        double angleDiff = thisAngle - lastAngle;
        if (angleDiff < 0.0) {
            angleDiff += Math.PI * 2;
        }
        if ((ccwAngleDiff = Math.PI * 2 - angleDiff) < angleDiff) {
            angleDiff = ccwAngleDiff;
        }
        return angleDiff;
    }

    private static boolean isLink(Edge edge) {
        return edge instanceof StreetEdge && (((StreetEdge)edge).getStreetClass() & 0x20) == 32;
    }

    private static List<P2<Double>> encodeElevationProfile(Edge edge, double distanceOffset, double heightOffset) {
        if (!(edge instanceof StreetEdge)) {
            return new ArrayList<P2<Double>>();
        }
        StreetEdge elevEdge = (StreetEdge)edge;
        if (elevEdge.getElevationProfile() == null) {
            return new ArrayList<P2<Double>>();
        }
        ArrayList<P2<Double>> out = new ArrayList<P2<Double>>();
        for (Coordinate coordinate : elevEdge.getElevationProfile().toCoordinateArray()) {
            out.add(new P2<Double>(coordinate.x + distanceOffset, coordinate.y + heightOffset));
        }
        return out;
    }
}

