/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.time.Instant;
import java.util.function.Consumer;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.routing.algorithm.filterchain.GroupBySimilarity;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilterChain;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilterChainBuilder;
import org.opentripplanner.routing.algorithm.filterchain.ListSection;
import org.opentripplanner.routing.api.request.ItineraryFilterParameters;

public class RoutingRequestToFilterChainMapper {
    private static final int KEEP_THREE = 3;
    private static final int MAX_NUMBER_OF_ITINERARIES = 200;

    public static ItineraryListFilterChain createFilterChain(SortOrder sortOrder, ItineraryFilterParameters params, int maxNumOfItineraries, Instant filterOnLatestDepartureTime, boolean removeWalkAllTheWayResults, boolean maxNumberOfItinerariesCropHead, Consumer<Itinerary> maxLimitReachedSubscriber) {
        ItineraryListFilterChainBuilder builder = new ItineraryListFilterChainBuilder(sortOrder);
        if (params.groupSimilarityKeepOne >= 0.5) {
            builder.addGroupBySimilarity(GroupBySimilarity.createWithOneItineraryPerGroup(params.groupSimilarityKeepOne));
        }
        if (params.groupSimilarityKeepThree >= 0.5) {
            builder.addGroupBySimilarity(GroupBySimilarity.createWithMoreThanOneItineraryPerGroup(params.groupSimilarityKeepThree, 3, true, params.groupedOtherThanSameLegsMaxCostMultiplier));
        }
        if (maxNumberOfItinerariesCropHead) {
            builder.withMaxNumberOfItinerariesCrop(ListSection.HEAD);
        }
        builder.withMaxNumberOfItineraries(Math.min(maxNumOfItineraries, 200)).withTransitGeneralizedCostLimit(params.transitGeneralizedCostLimit).withBikeRentalDistanceRatio(params.bikeRentalDistanceRatio).withParkAndRideDurationRatio(params.parkAndRideDurationRatio).withNonTransitGeneralizedCostLimit(params.nonTransitGeneralizedCostLimit).withRemoveTransitWithHigherCostThanBestOnStreetOnly(true).withLatestDepartureTimeLimit(filterOnLatestDepartureTime).withMaxLimitReachedSubscriber(maxLimitReachedSubscriber).withRemoveWalkAllTheWayResults(removeWalkAllTheWayResults).withDebugEnabled(params.debug);
        return builder.build();
    }
}

