/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.plan.FrequencyTransitLeg;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.routing.algorithm.mapping.AlertToLegMapper;
import org.opentripplanner.routing.algorithm.mapping.GraphPathToItineraryMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.AccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransferWithDuration;
import org.opentripplanner.routing.algorithm.transferoptimization.api.OptimizedPath;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.transit.raptor.api.path.AccessPathLeg;
import org.opentripplanner.transit.raptor.api.path.EgressPathLeg;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.path.PathLeg;
import org.opentripplanner.transit.raptor.api.path.TransferPathLeg;
import org.opentripplanner.transit.raptor.api.path.TransitPathLeg;

public class RaptorPathToItineraryMapper {
    private final Graph graph;
    private final TransitLayer transitLayer;
    private final RoutingRequest request;
    private final ZonedDateTime transitSearchTimeZero;

    public RaptorPathToItineraryMapper(Graph graph, TransitLayer transitLayer, ZonedDateTime transitSearchTimeZero, RoutingRequest request) {
        this.graph = graph;
        this.transitLayer = transitLayer;
        this.transitSearchTimeZero = transitSearchTimeZero;
        this.request = request;
    }

    public Itinerary createItinerary(Path<TripSchedule> path) {
        OptimizedPath optimizedPath = path instanceof OptimizedPath ? (OptimizedPath)path : null;
        ArrayList<Leg> legs = new ArrayList<Leg>(this.mapAccessLeg(path.accessLeg()));
        PathLeg<TripSchedule> pathLeg = path.accessLeg().nextLeg();
        boolean firstLeg = true;
        Leg transitLeg = null;
        while (!pathLeg.isEgressLeg()) {
            if (pathLeg.isTransitLeg()) {
                transitLeg = this.mapTransitLeg(transitLeg, pathLeg.asTransitLeg(), firstLeg);
                firstLeg = false;
                legs.add(transitLeg);
            } else if (pathLeg.isTransferLeg()) {
                legs.addAll(this.mapTransferLeg(pathLeg.asTransferLeg(), this.request.modes.transferMode == StreetMode.BIKE ? TraverseMode.BICYCLE : TraverseMode.WALK));
            }
            pathLeg = pathLeg.nextLeg();
        }
        EgressPathLeg<TripSchedule> egressPathLeg = pathLeg.asEgressLeg();
        Itinerary mapped = this.mapEgressLeg(egressPathLeg);
        legs.addAll(mapped == null ? List.of() : mapped.legs);
        Itinerary itinerary = new Itinerary(legs);
        itinerary.generalizedCost = RaptorCostConverter.toOtpDomainCost(path.generalizedCost());
        boolean bl = itinerary.arrivedAtDestinationWithRentedVehicle = mapped != null && mapped.arrivedAtDestinationWithRentedVehicle;
        if (optimizedPath != null) {
            itinerary.waitTimeOptimizedCost = RaptorCostConverter.toOtpDomainCost(optimizedPath.generalizedCostWaitTimeOptimized());
            itinerary.transferPriorityCost = RaptorCostConverter.toOtpDomainCost(optimizedPath.transferPriorityCost());
        }
        return itinerary;
    }

    private List<Leg> mapAccessLeg(AccessPathLeg<TripSchedule> accessPathLeg) {
        AccessEgress accessPath = (AccessEgress)accessPathLeg.access();
        if (accessPath.durationInSeconds() == 0) {
            return List.of();
        }
        GraphPath graphPath = new GraphPath(accessPath.getLastState());
        Itinerary subItinerary = GraphPathToItineraryMapper.generateItinerary(graphPath);
        if (subItinerary.legs.isEmpty()) {
            return List.of();
        }
        subItinerary.timeShiftToStartAt(this.createCalendar(accessPathLeg.fromTime()));
        return subItinerary.legs;
    }

    private Leg mapTransitLeg(Leg prevTransitLeg, TransitPathLeg<TripSchedule> pathLeg, boolean firstLeg) {
        ScheduledTransitLeg leg;
        TripSchedule tripSchedule = pathLeg.trip();
        int boardStopIndexInPattern = tripSchedule.findDepartureStopPosition(pathLeg.fromTime(), pathLeg.fromStop());
        int alightStopIndexInPattern = tripSchedule.findArrivalStopPosition(pathLeg.toTime(), pathLeg.toStop());
        if (tripSchedule.isFrequencyBasedTrip()) {
            int frequencyHeadwayInSeconds = tripSchedule.frequencyHeadwayInSeconds();
            leg = new FrequencyTransitLeg(tripSchedule.getOriginalTripTimes(), tripSchedule.getOriginalTripPattern(), boardStopIndexInPattern, alightStopIndexInPattern, this.createCalendar(pathLeg.fromTime() + frequencyHeadwayInSeconds), this.createCalendar(pathLeg.toTime()), tripSchedule.getServiceDate(), this.transitSearchTimeZero.getZone().normalized(), prevTransitLeg == null ? null : prevTransitLeg.getTransferToNextLeg(), (ConstrainedTransfer)pathLeg.getConstrainedTransferAfterLeg(), RaptorCostConverter.toOtpDomainCost(pathLeg.generalizedCost()), frequencyHeadwayInSeconds);
        } else {
            leg = new ScheduledTransitLeg(tripSchedule.getOriginalTripTimes(), tripSchedule.getOriginalTripPattern(), boardStopIndexInPattern, alightStopIndexInPattern, this.createCalendar(pathLeg.fromTime()), this.createCalendar(pathLeg.toTime()), tripSchedule.getServiceDate(), this.transitSearchTimeZero.getZone().normalized(), prevTransitLeg == null ? null : prevTransitLeg.getTransferToNextLeg(), (ConstrainedTransfer)pathLeg.getConstrainedTransferAfterLeg(), RaptorCostConverter.toOtpDomainCost(pathLeg.generalizedCost()));
        }
        AlertToLegMapper.addTransitAlertPatchesToLeg(this.graph, leg, firstLeg);
        return leg;
    }

    private List<Leg> mapTransferLeg(TransferPathLeg<TripSchedule> pathLeg, TraverseMode transferMode) {
        StopLocation transferFromStop = this.transitLayer.getStopByIndex(pathLeg.fromStop());
        StopLocation transferToStop = this.transitLayer.getStopByIndex(pathLeg.toStop());
        Transfer transfer = ((TransferWithDuration)pathLeg.transfer()).transfer();
        Place from = Place.forStop(transferFromStop);
        Place to = Place.forStop(transferToStop);
        return this.mapNonTransitLeg(pathLeg, transfer, transferMode, from, to);
    }

    private Itinerary mapEgressLeg(EgressPathLeg<TripSchedule> egressPathLeg) {
        AccessEgress egressPath = (AccessEgress)egressPathLeg.egress();
        if (egressPath.durationInSeconds() == 0) {
            return null;
        }
        GraphPath graphPath = new GraphPath(egressPath.getLastState());
        Itinerary subItinerary = GraphPathToItineraryMapper.generateItinerary(graphPath);
        if (subItinerary.legs.isEmpty()) {
            return null;
        }
        subItinerary.timeShiftToStartAt(this.createCalendar(egressPathLeg.fromTime()));
        return subItinerary;
    }

    private List<Leg> mapNonTransitLeg(PathLeg<TripSchedule> pathLeg, Transfer transfer, TraverseMode transferMode, Place from, Place to) {
        List<Edge> edges = transfer.getEdges();
        if (edges == null || edges.isEmpty()) {
            return List.of(new StreetLeg(transferMode, this.createCalendar(pathLeg.fromTime()), this.createCalendar(pathLeg.toTime()), from, to, Double.valueOf(transfer.getDistanceMeters()), RaptorCostConverter.toOtpDomainCost(pathLeg.generalizedCost()), GeometryUtils.makeLineString(transfer.getCoordinates()), List.of()));
        }
        try (RoutingRequest traverseRequest = Transfer.prepareTransferRoutingRequest(this.request);){
            traverseRequest.setRoutingContext(this.graph, (Vertex)null, null);
            traverseRequest.arriveBy = false;
            StateEditor se = new StateEditor(traverseRequest, edges.get(0).getFromVertex());
            se.setTimeSeconds(this.createCalendar(pathLeg.fromTime()).getTimeInMillis() / 1000L);
            State s = se.makeState();
            ArrayList<State> transferStates = new ArrayList<State>();
            transferStates.add(s);
            for (Edge e : edges) {
                s = e.traverse(s);
                transferStates.add(s);
            }
            State[] states = transferStates.toArray(new State[0]);
            GraphPath graphPath = new GraphPath(states[states.length - 1]);
            Itinerary subItinerary = GraphPathToItineraryMapper.generateItinerary(graphPath);
            if (subItinerary.legs.isEmpty()) {
                List<Leg> list = List.of();
                return list;
            }
            List<Leg> list = subItinerary.legs;
            return list;
        }
    }

    private Calendar createCalendar(int timeInSeconds) {
        ZonedDateTime zdt = this.transitSearchTimeZero.plusSeconds(timeInSeconds);
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(zdt.getZone()));
        c.setTimeInMillis(zdt.toInstant().toEpochMilli());
        return c;
    }
}

