/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.api.resource.CoordinateArrayListSequence;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.common.geometry.PackedCoordinateSequence;
import org.opentripplanner.ext.flex.FlexibleTransitLeg;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.routing.algorithm.mapping.AlertToLegMapper;
import org.opentripplanner.routing.algorithm.mapping.StatesToWalkStepsMapper;
import org.opentripplanner.routing.core.RoutingContext;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.PathwayEdge;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.VehicleParkingEdge;
import org.opentripplanner.routing.edgetype.VehicleRentalEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.location.TemporaryStreetLocation;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.routing.vertextype.VehicleParkingEntranceVertex;
import org.opentripplanner.routing.vertextype.VehicleRentalStationVertex;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphPathToItineraryMapper {
    private static final Logger LOG = LoggerFactory.getLogger(GraphPathToItineraryMapper.class);

    public static List<Itinerary> mapItineraries(List<GraphPath> paths) {
        LinkedList<Itinerary> itineraries = new LinkedList<Itinerary>();
        for (GraphPath path : paths) {
            Itinerary itinerary = GraphPathToItineraryMapper.generateItinerary(path);
            if (itinerary.legs.isEmpty()) continue;
            itineraries.add(itinerary);
        }
        return itineraries;
    }

    public static Itinerary generateItinerary(GraphPath path) {
        Graph graph = path.getRoutingContext().graph;
        ArrayList<Leg> legs = new ArrayList<Leg>();
        WalkStep previousStep = null;
        for (List<State> legStates : GraphPathToItineraryMapper.sliceStates(path.states)) {
            if (OTPFeature.FlexRouting.isOn() && legStates.get((int)1).backEdge instanceof FlexTripEdge) {
                legs.add(GraphPathToItineraryMapper.generateFlexLeg(graph, legStates));
                previousStep = null;
                continue;
            }
            StreetLeg leg = GraphPathToItineraryMapper.generateLeg(graph, legStates, previousStep);
            legs.add(leg);
            List<WalkStep> walkSteps = leg.getWalkSteps();
            if (walkSteps.size() > 0) {
                previousStep = walkSteps.get(walkSteps.size() - 1);
                continue;
            }
            previousStep = null;
        }
        Itinerary itinerary = new Itinerary(legs);
        GraphPathToItineraryMapper.calculateElevations(itinerary, path.edges);
        State lastState = path.states.getLast();
        itinerary.generalizedCost = (int)lastState.weight;
        itinerary.arrivedAtDestinationWithRentedVehicle = lastState.isRentingVehicleFromStation();
        return itinerary;
    }

    private static Calendar makeCalendar(State state) {
        RoutingContext rctx = state.getContext();
        TimeZone timeZone = rctx.graph.getTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTimeInMillis(state.getTimeInMillis());
        return calendar;
    }

    private static CoordinateArrayListSequence makeCoordinates(List<Edge> edges) {
        CoordinateArrayListSequence coordinates = new CoordinateArrayListSequence();
        for (Edge edge : edges) {
            LineString geometry = edge.getGeometry();
            if (geometry == null) continue;
            if (coordinates.size() == 0) {
                coordinates.extend(geometry.getCoordinates());
                continue;
            }
            coordinates.extend(geometry.getCoordinates(), 1);
        }
        return coordinates;
    }

    private static List<List<State>> sliceStates(List<State> states) {
        if (states.stream().allMatch(state -> state.getBackMode() == null)) {
            return List.of();
        }
        LinkedList<List<State>> legsStates = new LinkedList<List<State>>();
        int previousBreak = 0;
        for (int i = 1; i < states.size() - 1; ++i) {
            boolean parkingChange;
            State backState = states.get(i);
            State forwardState = states.get(i + 1);
            boolean flexChange = forwardState.backEdge instanceof FlexTripEdge || backState.backEdge instanceof FlexTripEdge;
            boolean rentalChange = GraphPathToItineraryMapper.isRentalPickUp(backState) || GraphPathToItineraryMapper.isRentalDropOff(backState);
            boolean bl = parkingChange = backState.isVehicleParked() != forwardState.isVehicleParked();
            if (!parkingChange && !flexChange && !rentalChange) continue;
            int nextBreak = i;
            if (parkingChange) {
                ++nextBreak;
            }
            if (nextBreak > previousBreak) {
                legsStates.add(states.subList(previousBreak, nextBreak + 1));
            }
            previousBreak = nextBreak;
        }
        if (states.size() > previousBreak) {
            legsStates.add(states.subList(previousBreak, states.size()));
        }
        return legsStates;
    }

    private static Leg generateFlexLeg(Graph graph, List<State> states) {
        State fromState = states.get(0);
        State toState = states.get(1);
        FlexTripEdge flexEdge = (FlexTripEdge)toState.backEdge;
        Calendar startTime = GraphPathToItineraryMapper.makeCalendar(fromState);
        Calendar endTime = GraphPathToItineraryMapper.makeCalendar(toState);
        int generalizedCost = (int)(toState.getWeight() - fromState.getWeight());
        FlexibleTransitLeg leg = new FlexibleTransitLeg(flexEdge, startTime, endTime, generalizedCost);
        AlertToLegMapper.addTransitAlertPatchesToLeg(graph, leg, true);
        return leg;
    }

    private static StreetLeg generateLeg(Graph graph, List<State> states, WalkStep previousStep) {
        String vehicleRentalNetwork;
        List<Edge> edges = states.stream().skip(1L).map(State::getBackEdge).collect(Collectors.toList());
        State firstState = states.get(0);
        State lastState = states.get(states.size() - 1);
        double distanceMeters = edges.stream().mapToDouble(Edge::getDistanceMeters).sum();
        CoordinateArrayListSequence coordinates = GraphPathToItineraryMapper.makeCoordinates(edges);
        LineString geometry = GeometryUtils.getGeometryFactory().createLineString((CoordinateSequence)coordinates);
        List<WalkStep> walkSteps = new StatesToWalkStepsMapper(graph, states, previousStep).generateWalkSteps();
        boolean previousStateIsVehicleParking = firstState.getBackState() != null && firstState.getBackEdge() instanceof VehicleParkingEdge;
        Calendar startTime = GraphPathToItineraryMapper.makeCalendar(previousStateIsVehicleParking ? firstState.getBackState() : firstState);
        StreetLeg leg = new StreetLeg(GraphPathToItineraryMapper.resolveMode(states), startTime, GraphPathToItineraryMapper.makeCalendar(lastState), GraphPathToItineraryMapper.makePlace(firstState), GraphPathToItineraryMapper.makePlace(lastState), distanceMeters, (int)(lastState.getWeight() - firstState.getWeight()), geometry, walkSteps);
        leg.setRentedVehicle(firstState.isRentingVehicle());
        leg.setWalkingBike(false);
        if (leg.getRentedVehicle().booleanValue() && (vehicleRentalNetwork = firstState.getVehicleRentalNetwork()) != null) {
            leg.setVehicleRentalNetwork(vehicleRentalNetwork);
        }
        GraphPathToItineraryMapper.addStreetNotes(graph, leg, states);
        GraphPathToItineraryMapper.setPathwayInfo(leg, states);
        return leg;
    }

    private static void setPathwayInfo(StreetLeg leg, List<State> legStates) {
        for (State legsState : legStates) {
            if (!(legsState.getBackEdge() instanceof PathwayEdge)) continue;
            PathwayEdge pe = (PathwayEdge)legsState.getBackEdge();
            leg.setPathwayId(pe.getId());
            return;
        }
    }

    private static void calculateElevations(Itinerary itinerary, List<Edge> edges) {
        for (Edge edge : edges) {
            StreetEdge edgeWithElevation;
            PackedCoordinateSequence coordinates;
            if (!(edge instanceof StreetEdge) || (coordinates = (edgeWithElevation = (StreetEdge)edge).getElevationProfile()) == null || coordinates.getDimension() != 2) continue;
            for (int i = 0; i < coordinates.size() - 1; ++i) {
                Itinerary itinerary2;
                double change = coordinates.getOrdinate(i + 1, 1) - coordinates.getOrdinate(i, 1);
                if (change > 0.0) {
                    itinerary2 = itinerary;
                    Double.valueOf(itinerary2.elevationGained + change);
                    itinerary2.elevationGained = itinerary2.elevationGained;
                    continue;
                }
                if (!(change < 0.0)) continue;
                itinerary2 = itinerary;
                Double.valueOf(itinerary2.elevationLost - change);
                itinerary2.elevationLost = itinerary2.elevationLost;
            }
        }
    }

    private static TraverseMode resolveMode(List<State> states) {
        for (State state : states) {
            TraverseMode mode = state.getNonTransitMode();
            if (mode == null) continue;
            if (state.isRentingVehicle()) {
                switch (state.stateData.rentalVehicleFormFactor) {
                    case BICYCLE: 
                    case OTHER: {
                        return TraverseMode.BICYCLE;
                    }
                    case SCOOTER: 
                    case MOPED: {
                        return TraverseMode.SCOOTER;
                    }
                    case CAR: {
                        return TraverseMode.CAR;
                    }
                }
                continue;
            }
            return mode;
        }
        return TraverseMode.WALK;
    }

    private static void addStreetNotes(Graph graph, StreetLeg leg, List<State> states) {
        for (State state : states) {
            Set<StreetNote> streetNotes = graph.streetNotesService.getNotes(state);
            if (streetNotes == null) continue;
            for (StreetNote streetNote : streetNotes) {
                leg.addStretNote(streetNote);
            }
        }
    }

    private static Place makePlace(State state) {
        Vertex vertex = state.getVertex();
        I18NString name = vertex.getName();
        if (vertex instanceof StreetVertex && !(vertex instanceof TemporaryStreetLocation)) {
            name = ((StreetVertex)vertex).getIntersectionName();
        }
        if (vertex instanceof TransitStopVertex) {
            return Place.forStop(((TransitStopVertex)vertex).getStop());
        }
        if (vertex instanceof VehicleRentalStationVertex) {
            return Place.forVehicleRentalPlace((VehicleRentalStationVertex)vertex);
        }
        if (vertex instanceof VehicleParkingEntranceVertex) {
            return Place.forVehicleParkingEntrance((VehicleParkingEntranceVertex)vertex, state.getOptions());
        }
        return Place.normal(vertex, name);
    }

    public static boolean isRentalPickUp(State state) {
        return state.getBackEdge() instanceof VehicleRentalEdge && (state.getBackState() == null || !state.getBackState().isRentingVehicle());
    }

    public static boolean isRentalDropOff(State state) {
        return state.getBackEdge() instanceof VehicleRentalEdge && state.getBackState().isRentingVehicle();
    }
}

