/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.routing.alertpatch.StopCondition;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.services.TransitAlertService;

public class AlertToLegMapper {
    public static void addTransitAlertPatchesToLeg(Graph graph, Leg leg, boolean isFirstLeg) {
        Object alerts;
        if (!leg.isTransitLeg()) {
            return;
        }
        Set<StopCondition> departingStopConditions = isFirstLeg ? StopCondition.DEPARTURE : StopCondition.FIRST_DEPARTURE;
        Date legStartTime = leg.getStartTime().getTime();
        Date legEndTime = leg.getEndTime().getTime();
        StopLocation fromStop = leg.getFrom() == null ? null : leg.getFrom().stop;
        StopLocation toStop = leg.getTo() == null ? null : leg.getTo().stop;
        FeedScopedId routeId = leg.getRoute().getId();
        FeedScopedId tripId = leg.getTrip().getId();
        if (fromStop instanceof Stop) {
            alerts = AlertToLegMapper.getAlertsForStopAndRoute(graph, (Stop)fromStop, routeId);
            alerts.addAll(AlertToLegMapper.getAlertsForStopAndTrip(graph, (Stop)fromStop, tripId, leg.getServiceDate()));
            alerts.addAll(AlertToLegMapper.getAlertsForStop(graph, (Stop)fromStop));
            AlertToLegMapper.addTransitAlertPatchesToLeg(leg, departingStopConditions, (Collection<TransitAlert>)alerts, legStartTime, legEndTime);
        }
        if (toStop instanceof Stop) {
            alerts = AlertToLegMapper.getAlertsForStopAndRoute(graph, (Stop)toStop, routeId);
            alerts.addAll(AlertToLegMapper.getAlertsForStopAndTrip(graph, (Stop)toStop, tripId, leg.getServiceDate()));
            alerts.addAll(AlertToLegMapper.getAlertsForStop(graph, (Stop)toStop));
            AlertToLegMapper.addTransitAlertPatchesToLeg(leg, StopCondition.ARRIVING, (Collection<TransitAlert>)alerts, legStartTime, legEndTime);
        }
        if (leg.getIntermediateStops() != null) {
            for (StopArrival visit : leg.getIntermediateStops()) {
                if (!(visit.place.stop instanceof Stop)) continue;
                Stop stop = (Stop)visit.place.stop;
                Collection<TransitAlert> alerts2 = AlertToLegMapper.getAlertsForStopAndRoute(graph, stop, routeId);
                alerts2.addAll(AlertToLegMapper.getAlertsForStopAndTrip(graph, stop, tripId, leg.getServiceDate()));
                alerts2.addAll(AlertToLegMapper.getAlertsForStop(graph, stop));
                Date stopArrival = visit.arrival.getTime();
                Date stopDepature = visit.departure.getTime();
                AlertToLegMapper.addTransitAlertPatchesToLeg(leg, StopCondition.PASSING, alerts2, stopArrival, stopDepature);
            }
        }
        Collection<TransitAlert> patches = AlertToLegMapper.alertPatchService(graph).getTripAlerts(leg.getTrip().getId(), leg.getServiceDate());
        AlertToLegMapper.addTransitAlertPatchesToLeg(leg, patches, legStartTime, legEndTime);
        patches = AlertToLegMapper.alertPatchService(graph).getTripAlerts(leg.getTrip().getId(), null);
        AlertToLegMapper.addTransitAlertPatchesToLeg(leg, patches, legStartTime, legEndTime);
        patches = AlertToLegMapper.alertPatchService(graph).getRouteAlerts(leg.getRoute().getId());
        AlertToLegMapper.addTransitAlertPatchesToLeg(leg, patches, legStartTime, legEndTime);
        patches = AlertToLegMapper.alertPatchService(graph).getAgencyAlerts(leg.getAgency().getId());
        AlertToLegMapper.addTransitAlertPatchesToLeg(leg, patches, legStartTime, legEndTime);
        leg.getTransitAlerts().removeIf(alertPatch -> !alertPatch.displayDuring(leg.getStartTime().getTimeInMillis() / 1000L, leg.getEndTime().getTimeInMillis() / 1000L));
    }

    private static TransitAlertService alertPatchService(Graph g) {
        return g.getTransitAlertService();
    }

    private static Collection<TransitAlert> getAlertsForStopAndRoute(Graph graph, Stop stop, FeedScopedId routeId) {
        return AlertToLegMapper.getAlertsForStopAndRoute(graph, stop, routeId, true);
    }

    private static Collection<TransitAlert> getAlertsForStopAndRoute(Graph graph, Stop stop, FeedScopedId routeId, boolean checkParentStop) {
        if (stop == null) {
            return new ArrayList<TransitAlert>();
        }
        Collection<TransitAlert> alertsForStopAndRoute = graph.getTransitAlertService().getStopAndRouteAlerts(stop.getId(), routeId);
        if (checkParentStop) {
            if (alertsForStopAndRoute == null) {
                alertsForStopAndRoute = new HashSet<TransitAlert>();
            }
            if (stop.isPartOfStation()) {
                Collection<TransitAlert> alerts = graph.getTransitAlertService().getStopAndRouteAlerts(stop.getParentStation().getId(), routeId);
                if (alerts != null) {
                    alertsForStopAndRoute.addAll(alerts);
                }
                for (StopLocation siblingStop : stop.getParentStation().getChildStops()) {
                    Collection<TransitAlert> siblingAlerts;
                    if (stop.getId().equals(siblingStop.getId()) || (siblingAlerts = graph.getTransitAlertService().getStopAndRouteAlerts(stop.getParentStation().getId(), routeId)) == null) continue;
                    alertsForStopAndRoute.addAll(siblingAlerts);
                }
            }
        }
        return alertsForStopAndRoute;
    }

    private static Collection<TransitAlert> getAlertsForStopAndTrip(Graph graph, Stop stop, FeedScopedId tripId, ServiceDate serviceDate) {
        Collection<TransitAlert> alerts = AlertToLegMapper.getAlertsForStopAndTrip(graph, stop, tripId, true, serviceDate);
        alerts.addAll(AlertToLegMapper.getAlertsForStopAndTrip(graph, stop, tripId, true, null));
        return alerts;
    }

    private static Collection<TransitAlert> getAlertsForStopAndTrip(Graph graph, Stop stop, FeedScopedId tripId, boolean checkParentStop, ServiceDate serviceDate) {
        if (stop == null) {
            return new ArrayList<TransitAlert>();
        }
        Collection<TransitAlert> alertsForStopAndTrip = graph.getTransitAlertService().getStopAndTripAlerts(stop.getId(), tripId, serviceDate);
        if (checkParentStop) {
            if (alertsForStopAndTrip == null) {
                alertsForStopAndTrip = new HashSet<TransitAlert>();
            }
            if (stop.isPartOfStation()) {
                Collection<TransitAlert> alerts = graph.getTransitAlertService().getStopAndTripAlerts(stop.getParentStation().getId(), tripId, serviceDate);
                if (alerts != null) {
                    alertsForStopAndTrip.addAll(alerts);
                }
                for (StopLocation siblingStop : stop.getParentStation().getChildStops()) {
                    Collection<TransitAlert> siblingAlerts;
                    if (stop.getId().equals(siblingStop.getId()) || (siblingAlerts = graph.getTransitAlertService().getStopAndTripAlerts(stop.getParentStation().getId(), tripId, serviceDate)) == null) continue;
                    alertsForStopAndTrip.addAll(siblingAlerts);
                }
            }
        }
        return alertsForStopAndTrip;
    }

    private static Collection<TransitAlert> getAlertsForStop(Graph graph, Stop stopId) {
        return AlertToLegMapper.getAlertsForStop(graph, stopId, true);
    }

    private static Collection<TransitAlert> getAlertsForStop(Graph graph, Stop stop, boolean checkParentStop) {
        if (stop == null) {
            return new ArrayList<TransitAlert>();
        }
        Collection<TransitAlert> alertsForStop = graph.getTransitAlertService().getStopAlerts(stop.getId());
        if (checkParentStop) {
            if (alertsForStop == null) {
                alertsForStop = new HashSet<TransitAlert>();
            }
            if (stop.isPartOfStation()) {
                Collection<TransitAlert> parentStopAlerts = graph.getTransitAlertService().getStopAlerts(stop.getParentStation().getId());
                if (parentStopAlerts != null) {
                    alertsForStop.addAll(parentStopAlerts);
                }
                for (StopLocation siblingStop : stop.getParentStation().getChildStops()) {
                    Collection<TransitAlert> siblingAlerts;
                    if (stop.getId().equals(siblingStop.getId()) || (siblingAlerts = graph.getTransitAlertService().getStopAlerts(stop.getParentStation().getId())) == null) continue;
                    alertsForStop.addAll(siblingAlerts);
                }
            }
        }
        return alertsForStop;
    }

    private static void addTransitAlertPatchesToLeg(Leg leg, Collection<StopCondition> stopConditions, Collection<TransitAlert> alertPatches, Date fromTime, Date toTime) {
        if (alertPatches != null) {
            block0: for (TransitAlert alert : alertPatches) {
                if (!alert.displayDuring(fromTime.getTime() / 1000L, toTime.getTime() / 1000L)) continue;
                if (!alert.getStopConditions().isEmpty() && stopConditions != null && !stopConditions.isEmpty()) {
                    for (StopCondition stopCondition : stopConditions) {
                        if (!alert.getStopConditions().contains((Object)stopCondition)) continue;
                        leg.addAlert(alert);
                        continue block0;
                    }
                    continue;
                }
                leg.addAlert(alert);
            }
        }
    }

    private static void addTransitAlertPatchesToLeg(Leg leg, Collection<TransitAlert> alertPatches, Date fromTime, Date toTime) {
        AlertToLegMapper.addTransitAlertPatchesToLeg(leg, null, alertPatches, fromTime, toTime);
    }
}

