/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.groupids;

import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.algorithm.filterchain.groupids.GroupId;

public class GroupByTripIdAndDistance
implements GroupId<GroupByTripIdAndDistance> {
    private final List<Leg> keySet;

    public GroupByTripIdAndDistance(Itinerary itinerary, double p) {
        this.assertPIsValid(p);
        List<Leg> transitLegs = itinerary.legs.stream().filter(Leg::isTransitLeg).collect(Collectors.toList());
        if (transitLegs.isEmpty()) {
            this.keySet = List.of();
        } else {
            double limit = p * GroupByTripIdAndDistance.calculateTotalDistance(itinerary.legs);
            this.keySet = GroupByTripIdAndDistance.getKeySetOfLegsByLimit(transitLegs, limit);
        }
    }

    @Override
    public GroupByTripIdAndDistance merge(GroupByTripIdAndDistance other) {
        return this.keySet.size() <= other.keySet.size() ? this : other;
    }

    @Override
    public boolean match(GroupByTripIdAndDistance other) {
        if (this == other) {
            return true;
        }
        if (this.keySet.isEmpty() || other.keySet.isEmpty()) {
            return false;
        }
        return GroupByTripIdAndDistance.isTheSame(this.keySet, other.keySet);
    }

    static double calculateTotalDistance(List<Leg> transitLegs) {
        return transitLegs.stream().mapToDouble(it -> it.getDistanceMeters()).sum();
    }

    static List<Leg> getKeySetOfLegsByLimit(List<Leg> legs, double distanceLimitMeters) {
        legs = legs.stream().sorted((l, r) -> r.getDistanceMeters().compareTo(l.getDistanceMeters())).collect(Collectors.toList());
        double sum = 0.0;
        int i = 0;
        while (sum < distanceLimitMeters) {
            if (i == legs.size()) {
                return List.of();
            }
            sum += legs.get(i).getDistanceMeters().doubleValue();
            ++i;
        }
        return legs.stream().limit(i).collect(Collectors.toList());
    }

    List<Leg> getKeySet() {
        return List.copyOf(this.keySet);
    }

    public String toString() {
        return this.keySet.toString();
    }

    private void assertPIsValid(double p) {
        if (p > 0.99 || p < 0.5) {
            throw new IllegalArgumentException("'p' is not between 0.01 and 0.99: " + p);
        }
    }

    private static boolean isTheSame(List<Leg> a, List<Leg> b) {
        if (a.size() > b.size()) {
            List<Leg> temp = a;
            a = b;
            b = temp;
        }
        for (Leg aLeg : a) {
            if (!b.stream().noneMatch(aLeg::isPartiallySameTransitLeg)) continue;
            return false;
        }
        return true;
    }
}

