/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.groupids;

import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.StationElement;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.algorithm.filterchain.groupids.GroupId;

public class GroupByAllSameStations
implements GroupId<GroupByAllSameStations> {
    private final List<P2<FeedScopedId>> keySet;

    public GroupByAllSameStations(Itinerary itinerary) {
        this.keySet = itinerary.legs.stream().filter(Leg::isTransitLeg).map(leg -> new P2<FeedScopedId>(GroupByAllSameStations.getStopOrStationId(leg.getFrom().stop), GroupByAllSameStations.getStopOrStationId(leg.getTo().stop))).collect(Collectors.toList());
    }

    @Override
    public boolean match(GroupByAllSameStations other) {
        if (this == other) {
            return true;
        }
        if (this.keySet.isEmpty() || other.keySet.isEmpty()) {
            return false;
        }
        return this.keySet.equals(other.keySet);
    }

    @Override
    public GroupByAllSameStations merge(GroupByAllSameStations other) {
        return this;
    }

    private static FeedScopedId getStopOrStationId(StopLocation stopPlace) {
        if (stopPlace instanceof StationElement && ((StationElement)((Object)stopPlace)).isPartOfStation()) {
            return ((StationElement)((Object)stopPlace)).getParentStation().getId();
        }
        return stopPlace.getId();
    }
}

