/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filter;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.model.SystemNotice;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.ItineraryDeletionFlagger;

public class DeletionFlaggingFilter
implements ItineraryListFilter {
    private final ItineraryDeletionFlagger flagger;

    public DeletionFlaggingFilter(ItineraryDeletionFlagger flagger) {
        this.flagger = flagger;
    }

    public String name() {
        return this.flagger.name();
    }

    @Override
    public List<Itinerary> filter(List<Itinerary> itineraries) {
        List<Itinerary> filterInput = this.flagger.skipAlreadyFlaggedItineraries() ? itineraries.stream().filter(Predicate.not(Itinerary::isFlaggedForDeletion)).collect(Collectors.toList()) : itineraries;
        for (Itinerary it : this.flagger.getFlaggedItineraries(filterInput)) {
            it.flagForDeletion(new SystemNotice(this.flagger.name(), "This itinerary is marked as deleted by the " + this.flagger.name() + " filter."));
        }
        return itineraries;
    }
}

