/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.deletionflagger;

import java.util.List;
import java.util.OptionalDouble;
import java.util.function.DoubleFunction;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.ItineraryDeletionFlagger;

public class TransitGeneralizedCostFilter
implements ItineraryDeletionFlagger {
    private final DoubleFunction<Double> costLimitFunction;

    public TransitGeneralizedCostFilter(DoubleFunction<Double> costLimitFunction) {
        this.costLimitFunction = costLimitFunction;
    }

    @Override
    public String name() {
        return "transit-cost-filter";
    }

    @Override
    public List<Itinerary> getFlaggedItineraries(List<Itinerary> itineraries) {
        OptionalDouble minGeneralizedCost = itineraries.stream().filter(Itinerary::hasTransit).mapToDouble(it -> it.generalizedCost).min();
        if (minGeneralizedCost.isEmpty()) {
            return List.of();
        }
        double maxLimit = this.costLimitFunction.apply(minGeneralizedCost.getAsDouble());
        return itineraries.stream().filter(it -> it.hasTransit() && (double)it.generalizedCost > maxLimit).collect(Collectors.toList());
    }
}

