/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.deletionflagger;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.ItineraryDeletionFlagger;
import org.opentripplanner.routing.core.TraverseMode;

public class RemoveParkAndRideWithMostlyWalkingFilter
implements ItineraryDeletionFlagger {
    private final double parkAndRideDurationRatio;

    public RemoveParkAndRideWithMostlyWalkingFilter(double ratio) {
        this.parkAndRideDurationRatio = ratio;
    }

    @Override
    public String name() {
        return "park-and-ride-vs-walk-filter";
    }

    @Override
    public Predicate<Itinerary> predicate() {
        return itinerary -> {
            boolean containsTransit = itinerary.legs.stream().anyMatch(l -> l != null && l.getMode().isTransit());
            double carDuration = itinerary.legs.stream().filter(l -> l.getMode() == TraverseMode.CAR).mapToDouble(Leg::getDuration).sum();
            double totalDuration = itinerary.durationSeconds;
            return !containsTransit && carDuration != 0.0 && carDuration / totalDuration <= this.parkAndRideDurationRatio;
        };
    }

    @Override
    public List<Itinerary> getFlaggedItineraries(List<Itinerary> itineraries) {
        if (itineraries.size() == 1) {
            return List.of();
        }
        return itineraries.stream().filter(this.predicate()).collect(Collectors.toList());
    }
}

