/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.routing.algorithm.filterchain.GroupBySimilarity;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilter;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilterChain;
import org.opentripplanner.routing.algorithm.filterchain.ListSection;
import org.opentripplanner.routing.algorithm.filterchain.comparator.SortOrderComparator;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.LatestDepartureTimeFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.MaxLimitFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.NonTransitGeneralizedCostFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.OtherThanSameLegsMaxGeneralizedCostFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.RemoveBikerentalWithMostlyWalkingFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.RemoveParkAndRideWithMostlyWalkingFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.RemoveTransitIfStreetOnlyIsBetterFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.RemoveWalkOnlyFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.TransitGeneralizedCostFilter;
import org.opentripplanner.routing.algorithm.filterchain.filter.DeletionFlaggingFilter;
import org.opentripplanner.routing.algorithm.filterchain.filter.GroupByFilter;
import org.opentripplanner.routing.algorithm.filterchain.filter.RemoveDeletionFlagForLeastTransfersItinerary;
import org.opentripplanner.routing.algorithm.filterchain.filter.SortingFilter;
import org.opentripplanner.routing.algorithm.filterchain.groupids.GroupByAllSameStations;
import org.opentripplanner.routing.algorithm.filterchain.groupids.GroupByTripIdAndDistance;

public class ItineraryListFilterChainBuilder {
    private static final int NOT_SET = -1;
    private final SortOrder sortOrder;
    private final List<GroupBySimilarity> groupBySimilarity = new ArrayList<GroupBySimilarity>();
    private boolean debug = false;
    private int maxNumberOfItineraries = -1;
    private ListSection maxNumberOfItinerariesCrop = ListSection.TAIL;
    private boolean removeTransitWithHigherCostThanBestOnStreetOnly = true;
    private boolean removeWalkAllTheWayResults;
    private DoubleFunction<Double> transitGeneralizedCostLimit;
    private double bikeRentalDistanceRatio;
    private double parkAndRideDurationRatio;
    private DoubleFunction<Double> nonTransitGeneralizedCostLimit;
    private Instant latestDepartureTimeLimit = null;
    private Consumer<Itinerary> maxLimitReachedSubscriber;

    public ItineraryListFilterChainBuilder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public ItineraryListFilterChainBuilder withMaxNumberOfItineraries(int value) {
        this.maxNumberOfItineraries = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withMaxNumberOfItinerariesCrop(ListSection section) {
        this.maxNumberOfItinerariesCrop = section;
        return this;
    }

    public ItineraryListFilterChainBuilder addGroupBySimilarity(GroupBySimilarity groupBySimilarity) {
        this.groupBySimilarity.add(groupBySimilarity);
        return this;
    }

    public ItineraryListFilterChainBuilder withTransitGeneralizedCostLimit(DoubleFunction<Double> value) {
        this.transitGeneralizedCostLimit = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withNonTransitGeneralizedCostLimit(DoubleFunction<Double> value) {
        this.nonTransitGeneralizedCostLimit = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withBikeRentalDistanceRatio(double value) {
        this.bikeRentalDistanceRatio = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withParkAndRideDurationRatio(double value) {
        this.parkAndRideDurationRatio = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withRemoveTransitWithHigherCostThanBestOnStreetOnly(boolean value) {
        this.removeTransitWithHigherCostThanBestOnStreetOnly = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withDebugEnabled(boolean value) {
        this.debug = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withLatestDepartureTimeLimit(Instant latestDepartureTimeLimit) {
        this.latestDepartureTimeLimit = latestDepartureTimeLimit;
        return this;
    }

    public ItineraryListFilterChainBuilder withMaxLimitReachedSubscriber(Consumer<Itinerary> maxLimitReachedSubscriber) {
        this.maxLimitReachedSubscriber = maxLimitReachedSubscriber;
        return this;
    }

    public ItineraryListFilterChainBuilder withRemoveWalkAllTheWayResults(boolean enable) {
        this.removeWalkAllTheWayResults = enable;
        return this;
    }

    public ItineraryListFilterChain build() {
        ArrayList<ItineraryListFilter> filters = new ArrayList<ItineraryListFilter>();
        filters.addAll(this.buildGroupByTripIdAndDistanceFilters());
        if (this.transitGeneralizedCostLimit != null) {
            filters.add(new DeletionFlaggingFilter(new TransitGeneralizedCostFilter(this.transitGeneralizedCostLimit)));
        }
        if (this.nonTransitGeneralizedCostLimit != null) {
            filters.add(new DeletionFlaggingFilter(new NonTransitGeneralizedCostFilter(this.nonTransitGeneralizedCostLimit)));
        }
        if (this.removeTransitWithHigherCostThanBestOnStreetOnly) {
            filters.add(new DeletionFlaggingFilter(new RemoveTransitIfStreetOnlyIsBetterFilter()));
        }
        if (this.removeWalkAllTheWayResults) {
            filters.add(new DeletionFlaggingFilter(new RemoveWalkOnlyFilter()));
        }
        if (this.latestDepartureTimeLimit != null) {
            filters.add(new DeletionFlaggingFilter(new LatestDepartureTimeFilter(this.latestDepartureTimeLimit)));
        }
        if (this.bikeRentalDistanceRatio > 0.0) {
            filters.add(new DeletionFlaggingFilter(new RemoveBikerentalWithMostlyWalkingFilter(this.bikeRentalDistanceRatio)));
        }
        if (this.parkAndRideDurationRatio > 0.0) {
            filters.add(new DeletionFlaggingFilter(new RemoveParkAndRideWithMostlyWalkingFilter(this.parkAndRideDurationRatio)));
        }
        if (this.maxNumberOfItineraries > 0) {
            filters.add(new SortingFilter(SortOrderComparator.comparator(this.sortOrder)));
            filters.add(new DeletionFlaggingFilter(new MaxLimitFilter("number-of-itineraries-filter", this.maxNumberOfItineraries, this.maxNumberOfItinerariesCrop, this.maxLimitReachedSubscriber)));
        }
        filters.add(new SortingFilter(SortOrderComparator.comparator(this.sortOrder)));
        return new ItineraryListFilterChain(filters, this.debug);
    }

    private List<ItineraryListFilter> buildGroupByTripIdAndDistanceFilters() {
        List groupBy = this.groupBySimilarity.stream().sorted(Comparator.comparingDouble(o -> o.groupByP)).collect(Collectors.toList());
        ArrayList<ItineraryListFilter> groupByFilters = new ArrayList<ItineraryListFilter>();
        for (GroupBySimilarity it : groupBy) {
            String name = "similar-legs-filter-" + (int)(100.0 * it.groupByP) + "p-" + it.maxNumOfItinerariesPerGroup + "x";
            ArrayList<ItineraryListFilter> nested = new ArrayList<ItineraryListFilter>();
            if (it.nestedGroupingByAllSameStations) {
                String innerGroupName = name + "-group-by-all-same-stations";
                nested.add(new GroupByFilter<GroupByAllSameStations>(GroupByAllSameStations::new, List.of(new SortingFilter(SortOrderComparator.generalizedCostComparator()), new DeletionFlaggingFilter(new MaxLimitFilter(innerGroupName, 1)))));
            }
            if (it.maxCostOtherLegsFactor > 1.0) {
                nested.add(new DeletionFlaggingFilter(new OtherThanSameLegsMaxGeneralizedCostFilter(it.maxCostOtherLegsFactor)));
            }
            nested.add(new SortingFilter(SortOrderComparator.generalizedCostComparator()));
            nested.add(new DeletionFlaggingFilter(new MaxLimitFilter(name, it.maxNumOfItinerariesPerGroup)));
            nested.add(new RemoveDeletionFlagForLeastTransfersItinerary());
            groupByFilters.add(new GroupByFilter<GroupByTripIdAndDistance>(itinerary -> new GroupByTripIdAndDistance((Itinerary)itinerary, it.groupByP), nested));
        }
        return groupByFilters;
    }
}

