/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.astar.strategies;

import com.google.common.collect.Iterables;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.routing.algorithm.astar.strategies.RemainingWeightHeuristic;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.edgetype.FreeEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;

public class EuclideanRemainingWeightHeuristic
implements RemainingWeightHeuristic {
    private static final long serialVersionUID = -5172878150967231550L;
    private double lat;
    private double lon;
    private double maxStreetSpeed;

    @Override
    public void initialize(RoutingRequest options, long abortTime) {
        Edge edge;
        RoutingRequest req = options;
        Vertex target = req.rctx.toVertices.iterator().next();
        this.maxStreetSpeed = req.getStreetSpeedUpperBound();
        if (target.getDegreeIn() == 1 && (edge = (Edge)Iterables.getOnlyElement(target.getIncoming())) instanceof FreeEdge) {
            target = edge.getFromVertex();
        }
        this.lat = target.getLat();
        this.lon = target.getLon();
    }

    @Override
    public double estimateRemainingWeight(State s) {
        Vertex sv = s.getVertex();
        double euclideanDistance = SphericalDistanceLibrary.fastDistance(sv.getLat(), sv.getLon(), this.lat, this.lon);
        return euclideanDistance / this.maxStreetSpeed;
    }

    @Override
    public void reset() {
    }

    @Override
    public void doSomeWork() {
    }
}

