/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.astar;

import com.beust.jcommander.internal.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.opentripplanner.common.pqueue.BinHeap;
import org.opentripplanner.routing.algorithm.astar.TraverseVisitor;
import org.opentripplanner.routing.algorithm.astar.strategies.RemainingWeightHeuristic;
import org.opentripplanner.routing.algorithm.astar.strategies.SearchTerminationStrategy;
import org.opentripplanner.routing.algorithm.astar.strategies.SkipEdgeStrategy;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.RoutingContext;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.routing.spt.ShortestPathTree;
import org.opentripplanner.util.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AStar {
    private static final Logger LOG = LoggerFactory.getLogger(AStar.class);
    private boolean verbose = false;
    private TraverseVisitor traverseVisitor;
    private SkipEdgeStrategy skipEdgeStrategy;
    private RunState runState;

    public ShortestPathTree getShortestPathTree(RoutingRequest req) {
        return this.getShortestPathTree(req, -1.0, null);
    }

    public ShortestPathTree getShortestPathTree(RoutingRequest req, double relTimeoutSeconds) {
        return this.getShortestPathTree(req, relTimeoutSeconds, null);
    }

    public void startSearch(RoutingRequest options, SearchTerminationStrategy terminationStrategy, long abortTime) {
        this.startSearch(options, terminationStrategy, abortTime, true);
    }

    private void startSearch(RoutingRequest options, SearchTerminationStrategy terminationStrategy, long abortTime, boolean addToQueue) {
        this.runState = new RunState(options, terminationStrategy);
        this.runState.rctx = options.getRoutingContext();
        this.runState.spt = options.getNewShortestPathTree();
        this.runState.heuristic = this.runState.rctx.remainingWeightHeuristic;
        this.runState.heuristic.initialize(this.runState.options, abortTime);
        if (abortTime < Long.MAX_VALUE && System.currentTimeMillis() > abortTime) {
            LOG.warn("Timeout during initialization of goal direction heuristic.");
            this.runState = null;
            return;
        }
        int initialSize = this.runState.rctx.graph.getVertices().size();
        initialSize = (int)Math.ceil(2.0 * Math.sqrt((double)initialSize + 1.0));
        this.runState.pq = new BinHeap(initialSize);
        this.runState.nVisited = 0;
        this.runState.targetAcceptedStates = Lists.newArrayList();
        if (addToQueue) {
            for (State initialState : State.getInitialStates(options)) {
                this.runState.spt.add(initialState);
                this.runState.pq.insert(initialState, 0.0);
            }
        }
    }

    boolean iterate() {
        if (this.verbose) {
            double w = this.runState.pq.peek_min_key();
            System.out.println("pq min key = " + w);
        }
        this.runState.heuristic.doSomeWork();
        this.runState.u = this.runState.pq.extract_min();
        if (!this.runState.spt.visit(this.runState.u)) {
            return false;
        }
        if (this.traverseVisitor != null) {
            this.traverseVisitor.visitVertex(this.runState.u);
        }
        this.runState.u_vertex = this.runState.u.getVertex();
        if (this.verbose) {
            System.out.println("   vertex " + this.runState.u_vertex);
        }
        ++this.runState.nVisited;
        Collection<Edge> edges = this.runState.options.arriveBy ? this.runState.u_vertex.getIncoming() : this.runState.u_vertex.getOutgoing();
        for (Edge edge : edges) {
            if (this.skipEdgeStrategy != null && this.skipEdgeStrategy.shouldSkipEdge(this.runState.rctx.fromVertices, this.runState.rctx.toVertices, this.runState.u, edge, this.runState.spt, this.runState.options)) continue;
            for (State v = edge.traverse(this.runState.u); v != null; v = v.getNextResult()) {
                double remaining_w;
                if (this.traverseVisitor != null) {
                    this.traverseVisitor.visitEdge(edge, v);
                }
                if ((remaining_w = this.runState.heuristic.estimateRemainingWeight(v)) < 0.0 || Double.isInfinite(remaining_w)) continue;
                double estimate = v.getWeight() + remaining_w;
                if (this.verbose) {
                    System.out.println("      edge " + edge);
                    System.out.println("      " + this.runState.u.getWeight() + " -> " + v.getWeight() + "(w) + " + remaining_w + "(heur) = " + estimate + " vert = " + v.getVertex());
                }
                if (!this.runState.spt.add(v)) continue;
                if (this.traverseVisitor != null) {
                    this.traverseVisitor.visitEnqueue(v);
                }
                this.runState.pq.insert(v, estimate);
            }
        }
        return true;
    }

    void runSearch(long abortTime) {
        while (!this.runState.pq.empty()) {
            if (abortTime < Long.MAX_VALUE && System.currentTimeMillis() > abortTime) {
                LOG.warn("Search timeout. origin={} target={}", this.runState.rctx.fromVertices, this.runState.rctx.toVertices);
                this.runState.options.rctx.aborted = true;
                break;
            }
            if (!this.iterate()) continue;
            if (this.runState.terminationStrategy != null && this.runState.terminationStrategy.shouldSearchTerminate(this.runState.rctx.fromVertices, this.runState.rctx.toVertices, this.runState.u, this.runState.spt, this.runState.options)) break;
            if (this.runState.rctx.toVertices == null || !this.runState.rctx.toVertices.contains(this.runState.u_vertex) || !this.runState.u.isFinal()) continue;
            this.runState.targetAcceptedStates.add(this.runState.u);
            if (this.runState.targetAcceptedStates.size() < this.runState.options.getNumItinerariesForDirectStreetSearch()) continue;
            LOG.debug("total vertices visited {}", (Object)this.runState.nVisited);
            break;
        }
    }

    public ShortestPathTree getShortestPathTree(RoutingRequest options, double relTimeoutSeconds, SearchTerminationStrategy terminationStrategy) {
        ShortestPathTree spt = null;
        long abortTime = DateUtils.absoluteTimeout(relTimeoutSeconds);
        this.startSearch(options, terminationStrategy, abortTime);
        if (this.runState != null) {
            this.runSearch(abortTime);
            spt = this.runState.spt;
        }
        return spt;
    }

    public ShortestPathTree getShortestPathTree(RoutingRequest options, double relTimeoutSeconds, SearchTerminationStrategy terminationStrategy, Collection<State> initialStates) {
        ShortestPathTree spt = null;
        long abortTime = DateUtils.absoluteTimeout(relTimeoutSeconds);
        this.startSearch(options, terminationStrategy, abortTime, false);
        if (this.runState != null) {
            for (State state : initialStates) {
                this.runState.spt.add(state);
                this.runState.pq.insert(state, state.getElapsedTimeSeconds());
            }
            this.runSearch(abortTime);
            spt = this.runState.spt;
        }
        return spt;
    }

    public void setTraverseVisitor(TraverseVisitor traverseVisitor) {
        this.traverseVisitor = traverseVisitor;
    }

    public List<GraphPath> getPathsToTarget() {
        if (this.runState == null) {
            return Collections.emptyList();
        }
        LinkedList<GraphPath> ret = new LinkedList<GraphPath>();
        for (State s : this.runState.targetAcceptedStates) {
            if (!s.isFinal()) continue;
            ret.add(new GraphPath(s));
        }
        return ret;
    }

    public void setSkipEdgeStrategy(SkipEdgeStrategy skipEdgeStrategy) {
        this.skipEdgeStrategy = skipEdgeStrategy;
    }

    class RunState {
        public State u;
        public ShortestPathTree spt;
        BinHeap<State> pq;
        RemainingWeightHeuristic heuristic;
        public RoutingContext rctx;
        public int nVisited;
        public List<State> targetAcceptedStates;
        public RunStatus status;
        private RoutingRequest options;
        private SearchTerminationStrategy terminationStrategy;
        public Vertex u_vertex;

        public RunState(RoutingRequest options, SearchTerminationStrategy terminationStrategy) {
            this.options = options;
            this.terminationStrategy = terminationStrategy;
        }
    }

    static enum RunStatus {
        RUNNING,
        STOPPED;

    }
}

