/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.alertpatch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.routing.alertpatch.AlertCause;
import org.opentripplanner.routing.alertpatch.AlertEffect;
import org.opentripplanner.routing.alertpatch.AlertSeverity;
import org.opentripplanner.routing.alertpatch.AlertUrl;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.StopCondition;
import org.opentripplanner.routing.alertpatch.TimePeriod;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.util.I18NString;

public class TransitAlert
implements Serializable {
    private static final long serialVersionUID = 8305126586053909836L;
    private String id;
    public I18NString alertHeaderText;
    public I18NString alertDescriptionText;
    public I18NString alertDetailText;
    public I18NString alertAdviceText;
    public I18NString alertUrl;
    private List<AlertUrl> alertUrlList = new ArrayList<AlertUrl>();
    public String alertType;
    public AlertSeverity severity;
    public AlertCause cause;
    public AlertEffect effect;
    public Integer priority;
    private List<TimePeriod> timePeriods = new ArrayList<TimePeriod>();
    private String feedId;
    private final Set<EntitySelector> entities = new HashSet<EntitySelector>();
    private final Collection<StopCondition> stopConditions = new ArrayList<StopCondition>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<AlertUrl> getAlertUrlList() {
        return this.alertUrlList;
    }

    public void setAlertUrlList(List<AlertUrl> alertUrlList) {
        this.alertUrlList = alertUrlList;
    }

    public boolean displayDuring(State state) {
        return this.displayDuring(state.getStartTimeSeconds(), state.getTimeSeconds());
    }

    public boolean displayDuring(long startTimeSeconds, long endTimeSeconds) {
        for (TimePeriod timePeriod : this.timePeriods) {
            if (endTimeSeconds < timePeriod.startTime || timePeriod.endTime != 0L && startTimeSeconds >= timePeriod.endTime) continue;
            return true;
        }
        return false;
    }

    public void setTimePeriods(List<TimePeriod> periods) {
        this.timePeriods = periods;
    }

    public void addEntity(EntitySelector entitySelector) {
        this.entities.add(entitySelector);
    }

    public Set<EntitySelector> getEntities() {
        return this.entities;
    }

    public Collection<StopCondition> getStopConditions() {
        return this.stopConditions;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public void setFeedId(String feedId) {
        this.feedId = feedId;
    }

    public Date getEffectiveStartDate() {
        return this.timePeriods.stream().map(timePeriod -> timePeriod.startTime).min(Comparator.naturalOrder()).filter(startTime -> startTime > 0L).map(startTime -> new Date(startTime * 1000L)).orElse(null);
    }

    public Date getEffectiveEndDate() {
        return this.timePeriods.stream().map(timePeriod -> timePeriod.endTime).max(Comparator.naturalOrder()).filter(endTime -> endTime < Long.MAX_VALUE).map(endTime -> new Date(endTime * 1000L)).orElse(null);
    }

    public String toString() {
        return "Alert('" + (this.alertHeaderText != null ? this.alertHeaderText.toString() : (this.alertDescriptionText != null ? this.alertDescriptionText.toString() : (this.alertDetailText != null ? this.alertDetailText.toString() : (this.alertAdviceText != null ? this.alertAdviceText.toString() : "?")))) + "')";
    }
}

