/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.alertpatch;

import java.util.Objects;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.calendar.ServiceDate;

public interface EntitySelector {

    public static class StopAndRouteOrTripKey {
        public final FeedScopedId stop;
        public final FeedScopedId routeOrTrip;
        public final ServiceDate serviceDate;
        private final transient int hash;

        public StopAndRouteOrTripKey(FeedScopedId stop, FeedScopedId routeOrTrip) {
            this(stop, routeOrTrip, null);
        }

        public StopAndRouteOrTripKey(FeedScopedId stop, FeedScopedId routeOrTrip, ServiceDate serviceDate) {
            this.stop = stop;
            this.routeOrTrip = routeOrTrip;
            this.serviceDate = serviceDate;
            this.hash = Objects.hash(stop, serviceDate, routeOrTrip);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StopAndRouteOrTripKey that = (StopAndRouteOrTripKey)o;
            if (!this.stop.equals(that.stop)) {
                return false;
            }
            if (!this.routeOrTrip.equals(that.routeOrTrip)) {
                return false;
            }
            return this.serviceDate != null ? this.serviceDate.equals(that.serviceDate) : that.serviceDate == null;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    public static class DirectionAndRoute
    implements EntitySelector {
        public final int directionId;
        public final FeedScopedId routeId;

        public DirectionAndRoute(int directionId, FeedScopedId routeId) {
            this.directionId = directionId;
            this.routeId = routeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DirectionAndRoute that = (DirectionAndRoute)o;
            return this.directionId == that.directionId && this.routeId.equals(that.routeId);
        }

        public int hashCode() {
            int routeHash = Objects.hash(this.routeId);
            return 41 * this.directionId * routeHash;
        }
    }

    public static class RouteTypeAndAgency
    implements EntitySelector {
        public final int routeType;
        public final FeedScopedId agencyId;

        public RouteTypeAndAgency(int routeType, FeedScopedId agencyId) {
            this.routeType = routeType;
            this.agencyId = agencyId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteTypeAndAgency that = (RouteTypeAndAgency)o;
            return this.routeType == that.routeType && this.agencyId.equals(that.agencyId);
        }

        public int hashCode() {
            int agencyHash = Objects.hash(this.agencyId);
            return 37 * this.routeType * agencyHash;
        }
    }

    public static class RouteType
    implements EntitySelector {
        public final int routeType;
        public final String feedId;

        public RouteType(int routeType, String feedId) {
            this.routeType = routeType;
            this.feedId = feedId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteType that = (RouteType)o;
            return this.routeType == that.routeType && this.feedId.equals(that.feedId);
        }

        public int hashCode() {
            return 37 * this.routeType * Objects.hash(this.feedId);
        }
    }

    public static class Unknown
    implements EntitySelector {
        public final String description;

        public Unknown(String description) {
            this.description = description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unknown that = (Unknown)o;
            return this.description.equals(that.description);
        }

        public int hashCode() {
            return Objects.hash(this.description);
        }
    }

    public static class StopAndTrip
    implements EntitySelector {
        public final StopAndRouteOrTripKey stopAndTrip;

        public StopAndTrip(FeedScopedId stopId, FeedScopedId tripId) {
            this(stopId, tripId, null);
        }

        public StopAndTrip(FeedScopedId stopId, FeedScopedId tripId, ServiceDate serviceDate) {
            this.stopAndTrip = new StopAndRouteOrTripKey(stopId, tripId, serviceDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StopAndTrip that = (StopAndTrip)o;
            return this.stopAndTrip.equals(that.stopAndTrip);
        }

        public int hashCode() {
            return this.stopAndTrip.hashCode();
        }
    }

    public static class StopAndRoute
    implements EntitySelector {
        public final StopAndRouteOrTripKey stopAndRoute;

        public StopAndRoute(FeedScopedId stopId, FeedScopedId routeId) {
            this.stopAndRoute = new StopAndRouteOrTripKey(stopId, routeId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StopAndRoute that = (StopAndRoute)o;
            return this.stopAndRoute.equals(that.stopAndRoute);
        }

        public int hashCode() {
            return this.stopAndRoute.hashCode();
        }
    }

    public static class Trip
    implements EntitySelector {
        public final FeedScopedId tripId;
        public final ServiceDate serviceDate;
        private transient int hash = -1;

        public Trip(FeedScopedId tripId) {
            this(tripId, null);
        }

        public Trip(FeedScopedId tripId, ServiceDate serviceDate) {
            this.tripId = tripId;
            this.serviceDate = serviceDate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Trip trip = (Trip)o;
            if (this.serviceDate != null && trip.serviceDate != null && !this.serviceDate.equals(trip.serviceDate)) {
                return false;
            }
            return this.tripId.equals(trip.tripId);
        }

        public int hashCode() {
            if (this.hash == -1) {
                int serviceDateResult = this.serviceDate == null ? 0 : this.serviceDate.hashCode();
                this.hash = 31 * serviceDateResult + this.tripId.hashCode();
            }
            return this.hash;
        }
    }

    public static class Route
    implements EntitySelector {
        public final FeedScopedId routeId;

        public Route(FeedScopedId routeId) {
            this.routeId = routeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Route route = (Route)o;
            return this.routeId.equals(route.routeId);
        }

        public int hashCode() {
            return this.routeId.hashCode();
        }
    }

    public static class Stop
    implements EntitySelector {
        public final FeedScopedId stopId;

        public Stop(FeedScopedId stopId) {
            this.stopId = stopId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stop stop = (Stop)o;
            return this.stopId.equals(stop.stopId);
        }

        public int hashCode() {
            return this.stopId.hashCode();
        }
    }

    public static class Agency
    implements EntitySelector {
        public final FeedScopedId agencyId;

        public Agency(FeedScopedId agencyId) {
            this.agencyId = agencyId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Agency agency = (Agency)o;
            return this.agencyId.equals(agency.agencyId);
        }

        public int hashCode() {
            return this.agencyId.hashCode();
        }
    }
}

