/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.core.ServiceDay;
import org.opentripplanner.routing.trippattern.TripTimes;

public class TripTimesShortHelper {
    public static List<TripTimeOnDate> getTripTimesShort(RoutingService routingService, Trip trip, ServiceDate serviceDate) {
        TripTimes times;
        ServiceDay serviceDay = new ServiceDay(routingService.getServiceCodes(), serviceDate, routingService.getCalendarService(), trip.getRoute().getAgency().getId());
        Timetable timetable = null;
        TimetableSnapshot timetableSnapshot = routingService.getTimetableSnapshot();
        if (timetableSnapshot != null) {
            TripPattern pattern = timetableSnapshot.getLastAddedTripPattern(trip.getId(), serviceDate);
            if (pattern == null) {
                pattern = routingService.getPatternForTrip().get(trip);
            }
            if ((timetable = timetableSnapshot.resolve(pattern, serviceDate)).getTripIndex(trip.getId()) == -1) {
                pattern = routingService.getPatternForTrip().get(trip);
                timetable = timetableSnapshot.resolve(pattern, serviceDate);
            }
        }
        if (timetable == null) {
            timetable = routingService.getPatternForTrip().get(trip).getScheduledTimetable();
        }
        if (!serviceDay.serviceRunning((times = timetable.getTripTimes(timetable.getTripIndex(trip.getId()))).getServiceCode())) {
            return new ArrayList<TripTimeOnDate>();
        }
        return TripTimeOnDate.fromTripTimes(timetable, trip, serviceDay);
    }
}

