/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing;

import com.google.common.collect.Multimap;
import gnu.trove.set.TIntSet;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.common.geometry.HashGridSpatialIndex;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.ext.flex.FlexIndex;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.linking.VertexLinker;
import org.opentripplanner.graph_builder.module.osm.WayPropertySetSource;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.GraphBundle;
import org.opentripplanner.model.MultiModalStation;
import org.opentripplanner.model.Notice;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.TimetableSnapshotProvider;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.WgsCoordinate;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.TripTimesShortHelper;
import org.opentripplanner.routing.algorithm.RoutingWorker;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.core.intersection_model.IntersectionTraversalCostModel;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.GraphIndex;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.graphfinder.GraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.routing.impl.StreetVertexIndex;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.routing.stoptimes.ArrivalDeparture;
import org.opentripplanner.routing.stoptimes.StopTimesHelper;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationService;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.standalone.server.Router;
import org.opentripplanner.util.WorldEnvelope;

public class RoutingService {
    private final Graph graph;
    private final GraphIndex graphIndex;
    private final GraphFinder graphFinder;
    private TimetableSnapshot timetableSnapshot;

    public RoutingService(Graph graph) {
        this.graph = graph;
        this.graphIndex = graph.index;
        this.graphFinder = GraphFinder.getInstance(graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutingResponse route(RoutingRequest request, Router router) {
        try {
            ZoneId zoneId = this.graph.getTimeZone().toZoneId();
            RoutingWorker worker = new RoutingWorker(router, request, zoneId);
            RoutingResponse routingResponse = worker.route();
            return routingResponse;
        }
        finally {
            if (request != null) {
                request.cleanup();
            }
        }
    }

    public List<StopTimesInPattern> stopTimesForStop(StopLocation stop, long startTime, int timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancelledTrips) {
        return StopTimesHelper.stopTimesForStop(this, this.lazyGetTimeTableSnapShot(), stop, startTime, timeRange, numberOfDepartures, arrivalDeparture, includeCancelledTrips);
    }

    public List<StopTimesInPattern> getStopTimesForStop(StopLocation stop, ServiceDate serviceDate, ArrivalDeparture arrivalDeparture) {
        return StopTimesHelper.stopTimesForStop(this, stop, serviceDate, arrivalDeparture);
    }

    public List<TripTimeOnDate> stopTimesForPatternAtStop(StopLocation stop, TripPattern pattern, long startTime, int timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture) {
        return StopTimesHelper.stopTimesForPatternAtStop(this, this.lazyGetTimeTableSnapShot(), stop, pattern, startTime, timeRange, numberOfDepartures, arrivalDeparture);
    }

    public Collection<TripPattern> getPatternsForStop(StopLocation stop, boolean includeRealtimeUpdates) {
        return this.graph.index.getPatternsForStop(stop, includeRealtimeUpdates ? this.lazyGetTimeTableSnapShot() : null);
    }

    public Timetable getTimetableForTripPattern(TripPattern tripPattern) {
        TimetableSnapshot timetableSnapshot = this.lazyGetTimeTableSnapShot();
        return timetableSnapshot != null ? timetableSnapshot.resolve(tripPattern, new ServiceDate(Calendar.getInstance().getTime())) : tripPattern.getScheduledTimetable();
    }

    public List<TripTimeOnDate> getTripTimesShort(Trip trip, ServiceDate serviceDate) {
        return TripTimesShortHelper.getTripTimesShort(this, trip, serviceDate);
    }

    public TimetableSnapshot getTimetableSnapshot() {
        return this.graph.getTimetableSnapshot();
    }

    public <T extends TimetableSnapshotProvider> T getOrSetupTimetableSnapshotProvider(Function<Graph, T> creator) {
        return this.graph.getOrSetupTimetableSnapshotProvider(creator);
    }

    public void addVertex(Vertex v) {
        this.graph.addVertex(v);
    }

    public void removeEdge(Edge e) {
        this.graph.removeEdge(e);
    }

    public Vertex getVertex(String label) {
        return this.graph.getVertex(label);
    }

    public Collection<Vertex> getVertices() {
        return this.graph.getVertices();
    }

    public <T extends Vertex> List<T> getVerticesOfType(Class<T> cls) {
        return this.graph.getVerticesOfType(cls);
    }

    public Collection<Edge> getEdges() {
        return this.graph.getEdges();
    }

    public <T extends Edge> List<T> getEdgesOfType(Class<T> cls) {
        return this.graph.getEdgesOfType(cls);
    }

    public Collection<StreetEdge> getStreetEdges() {
        return this.graph.getStreetEdges();
    }

    public TransitLayer getTransitLayer() {
        return this.graph.getTransitLayer();
    }

    public void setTransitLayer(TransitLayer transitLayer) {
        this.graph.setTransitLayer(transitLayer);
    }

    public TransitLayer getRealtimeTransitLayer() {
        return this.graph.getRealtimeTransitLayer();
    }

    public boolean hasRealtimeTransitLayer() {
        return this.graph.hasRealtimeTransitLayer();
    }

    public void setRealtimeTransitLayer(TransitLayer realtimeTransitLayer) {
        this.graph.setRealtimeTransitLayer(realtimeTransitLayer);
    }

    public boolean containsVertex(Vertex v) {
        return this.graph.containsVertex(v);
    }

    public <T extends Serializable> T putService(Class<T> serviceType, T service) {
        return this.graph.putService(serviceType, service);
    }

    public boolean hasService(Class<? extends Serializable> serviceType) {
        return this.graph.hasService(serviceType);
    }

    public <T extends Serializable> T getService(Class<T> serviceType) {
        return this.graph.getService(serviceType);
    }

    public <T extends Serializable> T getService(Class<T> serviceType, boolean autoCreate) {
        return this.graph.getService(serviceType, autoCreate);
    }

    public void remove(Vertex vertex) {
        this.graph.remove(vertex);
    }

    public void removeIfUnconnected(Vertex v) {
        this.graph.removeIfUnconnected(v);
    }

    public Envelope getExtent() {
        return this.graph.getExtent();
    }

    public TransferService getTransferService() {
        return this.graph.getTransferService();
    }

    public void updateTransitFeedValidity(CalendarServiceData data, DataImportIssueStore issueStore) {
        this.graph.updateTransitFeedValidity(data, issueStore);
    }

    public boolean transitFeedCovers(Instant time) {
        return this.graph.transitFeedCovers(time);
    }

    public GraphBundle getBundle() {
        return this.graph.getBundle();
    }

    public void setBundle(GraphBundle bundle) {
        this.graph.setBundle(bundle);
    }

    public int countVertices() {
        return this.graph.countVertices();
    }

    public int countEdges() {
        return this.graph.countEdges();
    }

    public void addTransitMode(TransitMode mode) {
        this.graph.addTransitMode(mode);
    }

    public HashSet<TransitMode> getTransitModes() {
        return this.graph.getTransitModes();
    }

    public CalendarService getCalendarService() {
        return this.graph.getCalendarService();
    }

    public CalendarServiceData getCalendarDataService() {
        return this.graph.getCalendarDataService();
    }

    public void clearCachedCalenderService() {
        this.graph.clearCachedCalenderService();
    }

    public StreetVertexIndex getStreetIndex() {
        return this.graph.getStreetIndex();
    }

    public VertexLinker getLinker() {
        return this.graph.getLinker();
    }

    public FeedScopedId getOrCreateServiceIdForDate(ServiceDate serviceDate) {
        return this.graph.getOrCreateServiceIdForDate(serviceDate);
    }

    public int removeEdgelessVertices() {
        return this.graph.removeEdgelessVertices();
    }

    public Collection<String> getFeedIds() {
        return this.graph.getFeedIds();
    }

    public Collection<Agency> getAgencies() {
        return this.graph.getAgencies();
    }

    public FeedInfo getFeedInfo(String feedId) {
        return this.graph.getFeedInfo(feedId);
    }

    public void addAgency(String feedId, Agency agency) {
        this.graph.addAgency(feedId, agency);
    }

    public void addFeedInfo(FeedInfo info) {
        this.graph.addFeedInfo(info);
    }

    public TimeZone getTimeZone() {
        return this.graph.getTimeZone();
    }

    public Collection<Operator> getOperators() {
        return this.graph.getOperators();
    }

    public void clearTimeZone() {
        this.graph.clearTimeZone();
    }

    public void calculateEnvelope() {
        this.graph.calculateEnvelope();
    }

    public void calculateConvexHull() {
        this.graph.calculateConvexHull();
    }

    public Geometry getConvexHull() {
        return this.graph.getConvexHull();
    }

    public void expandToInclude(double x, double y) {
        this.graph.expandToInclude(x, y);
    }

    public WorldEnvelope getEnvelope() {
        return this.graph.getEnvelope();
    }

    public void calculateTransitCenter() {
        this.graph.calculateTransitCenter();
    }

    public Optional<Coordinate> getCenter() {
        return this.graph.getCenter();
    }

    public long getTransitServiceStarts() {
        return this.graph.getTransitServiceStarts();
    }

    public long getTransitServiceEnds() {
        return this.graph.getTransitServiceEnds();
    }

    public Multimap<TransitEntity, Notice> getNoticesByElement() {
        return this.graph.getNoticesByElement();
    }

    public void addNoticeAssignments(Multimap<TransitEntity, Notice> noticesByElement) {
        this.graph.addNoticeAssignments(noticesByElement);
    }

    public double getDistanceBetweenElevationSamples() {
        return this.graph.getDistanceBetweenElevationSamples();
    }

    public void setDistanceBetweenElevationSamples(double distanceBetweenElevationSamples) {
        this.graph.setDistanceBetweenElevationSamples(distanceBetweenElevationSamples);
    }

    public TransitAlertService getTransitAlertService() {
        return this.graph.getTransitAlertService();
    }

    public Set<Vertex> getStopVerticesById(FeedScopedId id) {
        return this.graph.getStopVerticesById(id);
    }

    public BitSet getServicesRunningForDate(ServiceDate date) {
        return this.graph.getServicesRunningForDate(date);
    }

    public VehicleRentalStationService getVehicleRentalStationService() {
        return this.graph.getVehicleRentalStationService();
    }

    public VehicleParkingService getVehicleParkingService() {
        return this.graph.getVehicleParkingService();
    }

    public Collection<Notice> getNoticesByEntity(TransitEntity entity) {
        return this.graph.getNoticesByEntity(entity);
    }

    public TripPattern getTripPatternForId(FeedScopedId id) {
        return this.graph.getTripPatternForId(id);
    }

    public Collection<TripPattern> getTripPatterns() {
        return this.graph.getTripPatterns();
    }

    public Collection<Notice> getNotices() {
        return this.graph.getNotices();
    }

    public Collection<StopLocation> getStopsByBoundingBox(double minLat, double minLon, double maxLat, double maxLon) {
        return this.graph.getStopsByBoundingBox(minLat, minLon, maxLat, maxLon);
    }

    public List<T2<Stop, Double>> getStopsInRadius(WgsCoordinate center, double radius) {
        return this.graph.getStopsInRadius(center, radius);
    }

    public Station getStationById(FeedScopedId id) {
        return this.graph.getStationById(id);
    }

    public MultiModalStation getMultiModalStation(FeedScopedId id) {
        return this.graph.getMultiModalStation(id);
    }

    public Collection<Station> getStations() {
        return this.graph.getStations();
    }

    public Map<FeedScopedId, Integer> getServiceCodes() {
        return this.graph.getServiceCodes();
    }

    public Collection<PathTransfer> getTransfersByStop(StopLocation stop) {
        return this.graph.getTransfersByStop(stop);
    }

    public WayPropertySetSource.DrivingDirection getDrivingDirection() {
        return this.graph.getDrivingDirection();
    }

    public void setDrivingDirection(WayPropertySetSource.DrivingDirection drivingDirection) {
        this.graph.setDrivingDirection(drivingDirection);
    }

    public IntersectionTraversalCostModel getIntersectionTraversalModel() {
        return this.graph.getIntersectionTraversalModel();
    }

    public void setIntersectionTraversalCostModel(IntersectionTraversalCostModel intersectionTraversalCostModel) {
        this.graph.setIntersectionTraversalCostModel(intersectionTraversalCostModel);
    }

    public FlexStopLocation getLocationById(FeedScopedId id) {
        return this.graph.getLocationById(id);
    }

    public Set<StopLocation> getAllFlexStopsFlat() {
        return this.graph.getAllFlexStopsFlat();
    }

    public Agency getAgencyForId(FeedScopedId id) {
        return this.graphIndex.getAgencyForId(id);
    }

    public StopLocation getStopForId(FeedScopedId id) {
        return this.graphIndex.getStopForId(id);
    }

    public Route getRouteForId(FeedScopedId id) {
        return this.graphIndex.getRouteForId(id);
    }

    public void addRoutes(Route route) {
        this.graphIndex.addRoutes(route);
    }

    public Set<Route> getRoutesForStop(StopLocation stop) {
        return this.graphIndex.getRoutesForStop(stop);
    }

    public Collection<TripPattern> getPatternsForStop(StopLocation stop) {
        return this.graphIndex.getPatternsForStop(stop);
    }

    public Collection<TripPattern> getPatternsForStop(StopLocation stop, TimetableSnapshot timetableSnapshot) {
        return this.graphIndex.getPatternsForStop(stop, timetableSnapshot);
    }

    public Collection<Operator> getAllOperators() {
        return this.graphIndex.getAllOperators();
    }

    public Map<FeedScopedId, Operator> getOperatorForId() {
        return this.graphIndex.getOperatorForId();
    }

    public Collection<StopLocation> getAllStops() {
        return this.graphIndex.getAllStops();
    }

    public Map<FeedScopedId, Trip> getTripForId() {
        return this.graphIndex.getTripForId();
    }

    public Collection<Route> getAllRoutes() {
        return this.graphIndex.getAllRoutes();
    }

    public Map<Stop, TransitStopVertex> getStopVertexForStop() {
        return this.graphIndex.getStopVertexForStop();
    }

    public Map<Trip, TripPattern> getPatternForTrip() {
        return this.graphIndex.getPatternForTrip();
    }

    public Multimap<String, TripPattern> getPatternsForFeedId() {
        return this.graphIndex.getPatternsForFeedId();
    }

    public Multimap<Route, TripPattern> getPatternsForRoute() {
        return this.graphIndex.getPatternsForRoute();
    }

    public Map<Station, MultiModalStation> getMultiModalStationForStations() {
        return this.graphIndex.getMultiModalStationForStations();
    }

    public HashGridSpatialIndex<TransitStopVertex> getStopSpatialIndex() {
        return this.graphIndex.getStopSpatialIndex();
    }

    public Map<ServiceDate, TIntSet> getServiceCodesRunningForDate() {
        return this.graphIndex.getServiceCodesRunningForDate();
    }

    public FlexIndex getFlexIndex() {
        return this.graphIndex.getFlexIndex();
    }

    public List<NearbyStop> findClosestStops(double lat, double lon, double radiusMeters) {
        return this.graphFinder.findClosestStops(lat, lon, radiusMeters);
    }

    public List<PlaceAtDistance> findClosestPlaces(double lat, double lon, double radiusMeters, int maxResults, List<TransitMode> filterByModes, List<PlaceType> filterByPlaceTypes, List<FeedScopedId> filterByStops, List<FeedScopedId> filterByRoutes, List<String> filterByBikeRentalStations, List<String> filterByBikeParks, List<String> filterByCarParks, RoutingService routingService) {
        return this.graphFinder.findClosestPlaces(lat, lon, radiusMeters, maxResults, filterByModes, filterByPlaceTypes, filterByStops, filterByRoutes, filterByBikeRentalStations, filterByBikeParks, filterByCarParks, routingService);
    }

    private TimetableSnapshot lazyGetTimeTableSnapShot() {
        if (this.timetableSnapshot == null) {
            this.timetableSnapshot = this.graph.getTimetableSnapshot();
        }
        return this.timetableSnapshot;
    }
}

