/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.model;

import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import org.opentripplanner.openstreetmap.model.OSMNodeRef;
import org.opentripplanner.openstreetmap.model.OSMWithTags;

public class OSMWay
extends OSMWithTags {
    private TLongList nodes = new TLongArrayList();

    public void addNodeRef(OSMNodeRef nodeRef) {
        this.nodes.add(nodeRef.getRef());
    }

    public void addNodeRef(long nodeRef) {
        this.nodes.add(nodeRef);
    }

    public void addNodeRef(long nodeRef, int index) {
        this.nodes.insert(index, nodeRef);
    }

    public TLongList getNodeRefs() {
        return this.nodes;
    }

    public String toString() {
        return "osm way " + this.id;
    }

    public boolean isBicycleDismountForced() {
        String bicycle = this.getTag("bicycle");
        return this.isTag("cycleway", "dismount") != false || "dismount".equals(bicycle);
    }

    public boolean isSteps() {
        return "steps".equals(this.getTag("highway"));
    }

    public boolean isRoundabout() {
        return "roundabout".equals(this.getTag("junction"));
    }

    public boolean isOneWayForwardDriving() {
        return this.isTagTrue("oneway");
    }

    public boolean isOneWayReverseDriving() {
        return this.isTag("oneway", "-1");
    }

    public boolean isOneWayForwardBicycle() {
        String oneWayBicycle = this.getTag("oneway:bicycle");
        return OSMWay.isTrue(oneWayBicycle) || this.isTagFalse("bicycle:backwards");
    }

    public boolean isOneWayReverseBicycle() {
        return "-1".equals(this.getTag("oneway:bicycle"));
    }

    public boolean isForwardDirectionSidepath() {
        return "use_sidepath".equals(this.getTag("bicycle:forward"));
    }

    public boolean isReverseDirectionSidepath() {
        return "use_sidepath".equals(this.getTag("bicycle:backward"));
    }

    public boolean isOpposableCycleway() {
        String cycleway = this.getTag("cycleway");
        String cyclewayLeft = this.getTag("cycleway:left");
        String cyclewayRight = this.getTag("cycleway:right");
        return cycleway != null && cycleway.startsWith("opposite") || cyclewayLeft != null && cyclewayLeft.startsWith("opposite") || cyclewayRight != null && cyclewayRight.startsWith("opposite");
    }

    @Override
    public String getOpenStreetMapLink() {
        return String.format("http://www.openstreetmap.org/way/%d", this.getId());
    }
}

