/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.osmosis.osmbinary.file.BlockInputStream;
import org.openstreetmap.osmosis.osmbinary.file.BlockReaderAdapter;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.datastore.file.FileDataSource;
import org.opentripplanner.graph_builder.module.osm.OSMDatabase;
import org.opentripplanner.openstreetmap.BinaryOpenStreetMapParser;
import org.opentripplanner.openstreetmap.OsmParserPhase;
import org.opentripplanner.util.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryOpenStreetMapProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryOpenStreetMapProvider.class);
    private final DataSource source;
    private final boolean cacheDataImMem;
    private byte[] cachedBytes = null;

    public BinaryOpenStreetMapProvider(File file, boolean cacheDataImMem) {
        this(new FileDataSource(file, FileType.OSM), cacheDataImMem);
    }

    public BinaryOpenStreetMapProvider(DataSource source, boolean cacheDataImMem) {
        this.source = source;
        this.cacheDataImMem = cacheDataImMem;
    }

    public void readOSM(OSMDatabase osmdb) {
        try {
            BinaryOpenStreetMapParser parser = new BinaryOpenStreetMapParser(osmdb);
            this.parsePhase(parser, OsmParserPhase.Relations);
            osmdb.doneFirstPhaseRelations();
            this.parsePhase(parser, OsmParserPhase.Ways);
            osmdb.doneSecondPhaseWays();
            this.parsePhase(parser, OsmParserPhase.Nodes);
            osmdb.doneThirdPhaseNodes();
        }
        catch (Exception ex) {
            throw new IllegalStateException("error loading OSM from path " + this.source.path(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePhase(BinaryOpenStreetMapParser parser, OsmParserPhase phase) throws IOException {
        parser.setPhase(phase);
        BlockInputStream in = null;
        try {
            in = new BlockInputStream(this.createInputStream(phase), (BlockReaderAdapter)parser);
            in.process();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private InputStream createInputStream(OsmParserPhase phase) {
        if (this.cacheDataImMem) {
            if (this.cachedBytes == null) {
                this.cachedBytes = this.source.asBytes();
            }
            return BinaryOpenStreetMapProvider.track(phase, this.cachedBytes.length, new ByteArrayInputStream(this.cachedBytes));
        }
        return BinaryOpenStreetMapProvider.track(phase, this.source.size(), this.source.asInputStream());
    }

    private static InputStream track(OsmParserPhase phase, long size, InputStream inputStream) {
        return ProgressTracker.track("Parse OSM " + phase, 1000, size, inputStream, m -> LOG.info(m));
    }

    public String toString() {
        return "BinaryFileBasedOpenStreetMapProviderImpl(" + this.source.path() + ")";
    }

    public void checkInputs() {
        if (!this.source.exists()) {
            throw new RuntimeException("Can't read OSM path: " + this.source.path());
        }
    }
}

