/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.validation;

import org.opentripplanner.graph_builder.DataImportIssue;
import org.opentripplanner.netex.index.api.HMapValidationRule;
import org.opentripplanner.netex.validation.AbstractHMapValidationRule;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.JourneyPatternRefStructure;
import org.rutebanken.netex.model.ServiceJourney;

class JourneyPatternSJMismatch
extends AbstractHMapValidationRule<String, ServiceJourney> {
    JourneyPatternSJMismatch() {
    }

    @Override
    public HMapValidationRule.Status validate(String key, ServiceJourney sj) {
        int nTimetablePassingTimes;
        JourneyPattern journeyPattern = (JourneyPattern)this.index.getJourneyPatternsById().lookup(this.getPatternId(sj));
        int nStopPointsInJourneyPattern = journeyPattern.getPointsInSequence().getPointInJourneyPatternOrStopPointInJourneyPatternOrTimingPointInJourneyPattern().size();
        return nStopPointsInJourneyPattern != (nTimetablePassingTimes = sj.getPassingTimes().getTimetabledPassingTime().size()) ? HMapValidationRule.Status.DISCARD : HMapValidationRule.Status.OK;
    }

    @Override
    public DataImportIssue logMessage(String key, ServiceJourney sj) {
        return new StopPointsMismatch(sj.getId(), this.getPatternId(sj));
    }

    private String getPatternId(ServiceJourney sj) {
        return ((JourneyPatternRefStructure)sj.getJourneyPatternRef().getValue()).getRef();
    }

    private static class StopPointsMismatch
    implements DataImportIssue {
        private final String sjId;
        private final String patternId;

        public StopPointsMismatch(String sjId, String patternId) {
            this.sjId = sjId;
            this.patternId = patternId;
        }

        @Override
        public String getMessage() {
            return "Mismatch in stop points between ServiceJourney and JourneyPattern. ServiceJourney will be skipped.  ServiceJourney=" + this.sjId + ", JourneyPattern= " + this.patternId;
        }
    }
}

