/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.validation;

import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBElement;
import org.opentripplanner.graph_builder.DataImportIssue;
import org.opentripplanner.netex.index.api.HMapValidationRule;
import org.opentripplanner.netex.issues.ObjectNotFound;
import org.opentripplanner.netex.validation.AbstractHMapValidationRule;
import org.rutebanken.netex.model.DatedServiceJourney;
import org.rutebanken.netex.model.JourneyRefStructure;
import org.rutebanken.netex.model.ServiceJourney;

class DSJServiceJourneyNotFound
extends AbstractHMapValidationRule<String, DatedServiceJourney> {
    DSJServiceJourneyNotFound() {
    }

    @Override
    public HMapValidationRule.Status validate(String dsjId, DatedServiceJourney dsj) {
        String ref = this.getServiceJourneyRef(dsj);
        ServiceJourney sj = (ServiceJourney)this.index.getServiceJourneyById().lookup(ref);
        return sj == null ? HMapValidationRule.Status.DISCARD : HMapValidationRule.Status.OK;
    }

    @Override
    public DataImportIssue logMessage(String dsjId, DatedServiceJourney dsj) {
        String ref = this.getServiceJourneyRef(dsj);
        return new ObjectNotFound("DatedServiceJourney", dsj.getId(), "ServiceJourneyRef", ref);
    }

    @Nullable
    private String getServiceJourneyRef(DatedServiceJourney dsj) {
        List journeyRef = dsj.getJourneyRef();
        if (journeyRef == null || journeyRef.isEmpty()) {
            return null;
        }
        JourneyRefStructure ref = (JourneyRefStructure)((JAXBElement)journeyRef.get(0)).getValue();
        return ref == null ? null : ref.getRef();
    }
}

