/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.support;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBElement;
import org.opentripplanner.netex.support.DayTypeRefToServiceIdMapper;
import org.rutebanken.netex.model.DayTypeRefStructure;
import org.rutebanken.netex.model.DayTypeRefs_RelStructure;

public final class DayTypeRefsToServiceIdAdapter {
    private final Set<String> dayTypeRefs;
    private final String serviceId;

    @Nullable
    public static DayTypeRefsToServiceIdAdapter create(DayTypeRefs_RelStructure refs) {
        Set<String> dayTypeRefs = DayTypeRefsToServiceIdAdapter.collectDayTypeRefs(refs);
        return dayTypeRefs.isEmpty() ? null : new DayTypeRefsToServiceIdAdapter(dayTypeRefs);
    }

    @Nullable
    public static String createServiceId(DayTypeRefs_RelStructure refs) {
        Set<String> dayTypeRefs = DayTypeRefsToServiceIdAdapter.collectDayTypeRefs(refs);
        return dayTypeRefs.isEmpty() ? null : DayTypeRefToServiceIdMapper.generateServiceId(dayTypeRefs);
    }

    private static Set<String> collectDayTypeRefs(DayTypeRefs_RelStructure refs) {
        if (refs == null) {
            return Set.of();
        }
        HashSet<String> dayTypeRefs = new HashSet<String>();
        for (JAXBElement e : refs.getDayTypeRef()) {
            dayTypeRefs.add(((DayTypeRefStructure)e.getValue()).getRef());
        }
        return dayTypeRefs;
    }

    public DayTypeRefsToServiceIdAdapter(Set<String> dayTypeRefs) {
        this.dayTypeRefs = dayTypeRefs;
        this.serviceId = DayTypeRefToServiceIdMapper.generateServiceId(dayTypeRefs);
    }

    public Set<String> getDayTypeRefs() {
        return this.dayTypeRefs;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public int hashCode() {
        return this.dayTypeRefs.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DayTypeRefsToServiceIdAdapter)) {
            return false;
        }
        return this.dayTypeRefs.equals(((DayTypeRefsToServiceIdAdapter)obj).dayTypeRefs);
    }
}

