/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping.calendar;

import java.time.DayOfWeek;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.rutebanken.netex.model.DayOfWeekEnumeration;

class DayOfWeekMapper {
    private DayOfWeekMapper() {
    }

    static Set<DayOfWeek> mapDayOfWeeks(Collection<DayOfWeekEnumeration> values) {
        EnumSet<DayOfWeek> result = EnumSet.noneOf(DayOfWeek.class);
        for (DayOfWeekEnumeration it : values) {
            result.addAll(DayOfWeekMapper.mapDayOfWeek(it));
        }
        return result;
    }

    static Set<DayOfWeek> mapDayOfWeek(DayOfWeekEnumeration value) {
        switch (value) {
            case MONDAY: {
                return EnumSet.of(DayOfWeek.MONDAY);
            }
            case TUESDAY: {
                return EnumSet.of(DayOfWeek.TUESDAY);
            }
            case WEDNESDAY: {
                return EnumSet.of(DayOfWeek.WEDNESDAY);
            }
            case THURSDAY: {
                return EnumSet.of(DayOfWeek.THURSDAY);
            }
            case FRIDAY: {
                return EnumSet.of(DayOfWeek.FRIDAY);
            }
            case SATURDAY: {
                return EnumSet.of(DayOfWeek.SATURDAY);
            }
            case SUNDAY: {
                return EnumSet.of(DayOfWeek.SUNDAY);
            }
            case WEEKDAYS: {
                return EnumSet.range(DayOfWeek.MONDAY, DayOfWeek.FRIDAY);
            }
            case WEEKEND: {
                return EnumSet.range(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
            }
            case EVERYDAY: {
                return EnumSet.range(DayOfWeek.MONDAY, DayOfWeek.SUNDAY);
            }
            case NONE: {
                return EnumSet.noneOf(DayOfWeek.class);
            }
        }
        throw new IllegalArgumentException("Day of week enum mapping missing: " + value);
    }
}

