/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping.calendar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBElement;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMapById;
import org.opentripplanner.netex.mapping.calendar.OperatingDayMapper;
import org.opentripplanner.netex.mapping.support.ServiceAlterationFilter;
import org.rutebanken.netex.model.DatedServiceJourney;
import org.rutebanken.netex.model.JourneyRefStructure;
import org.rutebanken.netex.model.OperatingDay;
import org.rutebanken.netex.model.OperatingDayRefStructure;

public class DatedServiceJourneyMapper {
    public static Map<String, List<DatedServiceJourney>> indexDSJBySJId(ReadOnlyHierarchicalMapById<DatedServiceJourney> datedServiceJourneys) {
        HashMap<String, List<DatedServiceJourney>> dsjBySJId = new HashMap<String, List<DatedServiceJourney>>();
        for (DatedServiceJourney dsj : datedServiceJourneys.localValues()) {
            dsjBySJId.computeIfAbsent(((JourneyRefStructure)((JAXBElement)dsj.getJourneyRef().get(0)).getValue()).getRef(), it -> new ArrayList()).add(dsj);
        }
        return dsjBySJId;
    }

    public static Collection<ServiceDate> mapToServiceDates(Iterable<DatedServiceJourney> dsjs, ReadOnlyHierarchicalMapById<OperatingDay> operatingDayById) {
        ArrayList<ServiceDate> result = new ArrayList<ServiceDate>();
        for (DatedServiceJourney dsj : dsjs) {
            if (!ServiceAlterationFilter.isRunning(dsj.getServiceAlteration())) continue;
            OperatingDay opDay = DatedServiceJourneyMapper.operatingDay(dsj, operatingDayById);
            if (opDay != null) {
                result.add(OperatingDayMapper.map(opDay));
                continue;
            }
            throw new NullPointerException("DatedServiceJourney operating-day not found. DSJ Id: " + dsj.getId());
        }
        return result;
    }

    @Nullable
    private static OperatingDay operatingDay(DatedServiceJourney dsj, ReadOnlyHierarchicalMapById<OperatingDay> operatingDayById) {
        OperatingDayRefStructure operatingDayRef = dsj.getOperatingDayRef();
        return operatingDayRef == null ? null : (OperatingDay)operatingDayById.lookup(operatingDayRef.getRef());
    }
}

