/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.FlexLocationGroup;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopPattern;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.impl.EntityById;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMap;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMapById;
import org.opentripplanner.netex.mapping.StopTimesMapper;
import org.opentripplanner.netex.mapping.StopTimesMapperResult;
import org.opentripplanner.netex.mapping.TripMapper;
import org.opentripplanner.netex.mapping.TripPatternMapperResult;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.routing.trippattern.Deduplicator;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.rutebanken.netex.model.DestinationDisplay;
import org.rutebanken.netex.model.FlexibleLine;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.JourneyPatternRefStructure;
import org.rutebanken.netex.model.LineRefStructure;
import org.rutebanken.netex.model.Route;
import org.rutebanken.netex.model.ServiceJourney;

class TripPatternMapper {
    private final DataImportIssueStore issueStore;
    private final FeedScopedIdFactory idFactory;
    private final EntityById<org.opentripplanner.model.Route> otpRouteById;
    private final ReadOnlyHierarchicalMap<String, Route> routeById;
    private final Multimap<String, ServiceJourney> serviceJourniesByPatternId = ArrayListMultimap.create();
    private final TripMapper tripMapper;
    private final StopTimesMapper stopTimesMapper;
    private final Deduplicator deduplicator;
    private TripPatternMapperResult result;

    TripPatternMapper(DataImportIssueStore issueStore, FeedScopedIdFactory idFactory, EntityById<Operator> operatorById, EntityById<Stop> stopsById, EntityById<FlexStopLocation> flexStopLocationsById, EntityById<FlexLocationGroup> flexLocationGroupsById, EntityById<org.opentripplanner.model.Route> otpRouteById, Set<FeedScopedId> shapePointsIds, ReadOnlyHierarchicalMap<String, Route> routeById, ReadOnlyHierarchicalMap<String, JourneyPattern> journeyPatternById, ReadOnlyHierarchicalMap<String, String> quayIdByStopPointRef, ReadOnlyHierarchicalMap<String, String> flexibleStopPlaceIdByStopPointRef, ReadOnlyHierarchicalMap<String, DestinationDisplay> destinationDisplayById, ReadOnlyHierarchicalMap<String, ServiceJourney> serviceJourneyById, ReadOnlyHierarchicalMapById<FlexibleLine> flexibleLinesById, Map<String, FeedScopedId> serviceIds, Deduplicator deduplicator) {
        this.issueStore = issueStore;
        this.idFactory = idFactory;
        this.routeById = routeById;
        this.otpRouteById = otpRouteById;
        this.tripMapper = new TripMapper(idFactory, operatorById, otpRouteById, routeById, journeyPatternById, serviceIds, shapePointsIds);
        this.stopTimesMapper = new StopTimesMapper(issueStore, idFactory, stopsById, flexStopLocationsById, flexLocationGroupsById, destinationDisplayById, quayIdByStopPointRef, flexibleStopPlaceIdByStopPointRef, flexibleLinesById, routeById);
        this.deduplicator = deduplicator;
        for (ServiceJourney sj : serviceJourneyById.localValues()) {
            this.serviceJourniesByPatternId.put((Object)((JourneyPatternRefStructure)sj.getJourneyPatternRef().getValue()).getRef(), (Object)sj);
        }
    }

    TripPatternMapperResult mapTripPattern(JourneyPattern journeyPattern) {
        this.result = new TripPatternMapperResult();
        Collection serviceJourneys = this.serviceJourniesByPatternId.get((Object)journeyPattern.getId());
        if (serviceJourneys == null || serviceJourneys.isEmpty()) {
            this.issueStore.add("ServiceJourneyPatternIsEmpty", "ServiceJourneyPattern %s does not contain any serviceJourneys.", journeyPattern.getId());
            return this.result;
        }
        ArrayList<Trip> trips = new ArrayList<Trip>();
        for (ServiceJourney serviceJourney : serviceJourneys) {
            StopTimesMapperResult stopTimes;
            Trip trip = this.tripMapper.mapServiceJourney(serviceJourney);
            if (trip == null || (stopTimes = this.stopTimesMapper.mapToStopTimes(journeyPattern, trip, serviceJourney.getPassingTimes().getTimetabledPassingTime(), serviceJourney)) == null) continue;
            this.result.scheduledStopPointsIndex.putAll((Object)serviceJourney.getId(), stopTimes.scheduledStopPointIds);
            this.result.tripStopTimes.put(trip, stopTimes.stopTimes);
            this.result.stopTimeByNetexId.putAll(stopTimes.stopTimeByNetexId);
            trip.setTripHeadsign(TripPatternMapper.getHeadsign(stopTimes.stopTimes));
            trips.add(trip);
        }
        if (trips.isEmpty()) {
            return this.result;
        }
        if (this.result.tripStopTimes.get(trips.get(0)).stream().anyMatch(t -> t.getStop() instanceof FlexStopLocation || t.getStop() instanceof FlexLocationGroup)) {
            return this.result;
        }
        StopPattern stopPattern = this.deduplicator.deduplicateObject(StopPattern.class, new StopPattern((Collection<StopTime>)this.result.tripStopTimes.get(trips.get(0))));
        TripPattern tripPattern = new TripPattern(this.idFactory.createId(journeyPattern.getId()), this.lookupRoute(journeyPattern), stopPattern);
        tripPattern.setName(journeyPattern.getName() == null ? "" : journeyPattern.getName().getValue());
        this.createTripTimes(trips, tripPattern);
        this.result.tripPatterns.put((Object)stopPattern, (Object)tripPattern);
        return this.result;
    }

    private org.opentripplanner.model.Route lookupRoute(JourneyPattern journeyPattern) {
        Route route = this.routeById.lookup(journeyPattern.getRouteRef().getRef());
        return this.otpRouteById.get(this.idFactory.createId(((LineRefStructure)route.getLineRef().getValue()).getRef()));
    }

    private void createTripTimes(List<Trip> trips, TripPattern tripPattern) {
        for (Trip trip : trips) {
            if (this.result.tripStopTimes.get(trip).size() == 0) {
                this.issueStore.add("TripWithoutTripTimes", "Trip %s does not contain any trip times.", trip.getId());
                continue;
            }
            TripTimes tripTimes = new TripTimes(trip, (Collection<StopTime>)this.result.tripStopTimes.get(trip), this.deduplicator);
            tripPattern.add(tripTimes);
        }
    }

    private static String getHeadsign(List<StopTime> stopTimes) {
        if (stopTimes != null && stopTimes.size() > 0) {
            return ((StopTime)stopTimes.stream().findFirst().get()).getStopHeadsign();
        }
        return "";
    }
}

