/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBElement;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.impl.EntityById;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMap;
import org.opentripplanner.netex.mapping.DirectionMapper;
import org.opentripplanner.netex.mapping.TransportModeMapper;
import org.opentripplanner.netex.mapping.TripServiceAlterationMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.rutebanken.netex.model.DirectionTypeEnumeration;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.JourneyPatternRefStructure;
import org.rutebanken.netex.model.LineRefStructure;
import org.rutebanken.netex.model.OperatorRefStructure;
import org.rutebanken.netex.model.Route;
import org.rutebanken.netex.model.ServiceJourney;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TripMapper {
    private static final Logger LOG = LoggerFactory.getLogger(TripMapper.class);
    private final FeedScopedIdFactory idFactory;
    private final EntityById<org.opentripplanner.model.Route> otpRouteById;
    private final ReadOnlyHierarchicalMap<String, Route> routeById;
    private final ReadOnlyHierarchicalMap<String, JourneyPattern> journeyPatternsById;
    private final Map<String, FeedScopedId> serviceIds;
    private final Set<FeedScopedId> shapePointIds;
    private final EntityById<Operator> operatorsById;
    private final TransportModeMapper transportModeMapper = new TransportModeMapper();

    TripMapper(FeedScopedIdFactory idFactory, EntityById<Operator> operatorsById, EntityById<org.opentripplanner.model.Route> otpRouteById, ReadOnlyHierarchicalMap<String, Route> routeById, ReadOnlyHierarchicalMap<String, JourneyPattern> journeyPatternsById, Map<String, FeedScopedId> serviceIds, Set<FeedScopedId> shapePointIds) {
        this.idFactory = idFactory;
        this.otpRouteById = otpRouteById;
        this.routeById = routeById;
        this.journeyPatternsById = journeyPatternsById;
        this.serviceIds = serviceIds;
        this.shapePointIds = shapePointIds;
        this.operatorsById = operatorsById;
    }

    @Nullable
    Trip mapServiceJourney(ServiceJourney serviceJourney) {
        FeedScopedId serviceId = this.serviceIds.get(serviceJourney.getId());
        if (serviceId == null) {
            LOG.warn("Unable to map ServiceJourney, missing Route. SJ id: {}", (Object)serviceJourney.getId());
            return null;
        }
        org.opentripplanner.model.Route route = this.resolveRoute(serviceJourney);
        if (route == null) {
            LOG.warn("Unable to map ServiceJourney, missing serviceId. SJ id: {}", (Object)serviceJourney.getId());
            return null;
        }
        Trip trip = new Trip(this.idFactory.createId(serviceJourney.getId()));
        trip.setRoute(route);
        trip.setServiceId(serviceId);
        trip.setShapeId(this.getShapeId(serviceJourney));
        if (serviceJourney.getPrivateCode() != null) {
            trip.setInternalPlanningCode(serviceJourney.getPrivateCode().getValue());
        }
        trip.setTripShortName(serviceJourney.getPublicCode());
        trip.setTripOperator(this.findOperator(serviceJourney));
        if (serviceJourney.getTransportMode() != null) {
            T2<TransitMode, String> transitMode = this.transportModeMapper.map(serviceJourney.getTransportMode(), serviceJourney.getTransportSubmode());
            trip.setMode((TransitMode)((Object)transitMode.first));
            trip.setNetexSubmode((String)transitMode.second);
        }
        trip.setDirection(DirectionMapper.map(this.resolveDirectionType(serviceJourney)));
        trip.setAlteration(TripServiceAlterationMapper.mapAlteration(serviceJourney.getServiceAlteration()));
        return trip;
    }

    private DirectionTypeEnumeration resolveDirectionType(ServiceJourney serviceJourney) {
        Route netexRoute = this.lookUpNetexRoute(serviceJourney);
        if (netexRoute != null && netexRoute.getDirectionType() != null) {
            return netexRoute.getDirectionType();
        }
        return null;
    }

    @Nullable
    private FeedScopedId getShapeId(ServiceJourney serviceJourney) {
        JourneyPattern journeyPattern = this.journeyPatternsById.lookup(((JourneyPatternRefStructure)serviceJourney.getJourneyPatternRef().getValue()).getRef());
        FeedScopedId serviceLinkId = journeyPattern != null ? this.idFactory.createId(journeyPattern.getId().replace("JourneyPattern", "ServiceLink")) : null;
        return this.shapePointIds.contains(serviceLinkId) ? serviceLinkId : null;
    }

    private Route lookUpNetexRoute(ServiceJourney serviceJourney) {
        JourneyPattern journeyPattern;
        if (serviceJourney.getJourneyPatternRef() != null && (journeyPattern = this.journeyPatternsById.lookup(((JourneyPatternRefStructure)serviceJourney.getJourneyPatternRef().getValue()).getRef())) != null && journeyPattern.getRouteRef() != null) {
            String routeRef = journeyPattern.getRouteRef().getRef();
            return this.routeById.lookup(routeRef);
        }
        return null;
    }

    private org.opentripplanner.model.Route resolveRoute(ServiceJourney serviceJourney) {
        String lineRef = null;
        JAXBElement lineRefStruct = serviceJourney.getLineRef();
        if (lineRefStruct != null) {
            lineRef = ((LineRefStructure)lineRefStruct.getValue()).getRef();
        } else if (serviceJourney.getJourneyPatternRef() != null) {
            JourneyPattern journeyPattern = this.journeyPatternsById.lookup(((JourneyPatternRefStructure)serviceJourney.getJourneyPatternRef().getValue()).getRef());
            String routeRef = journeyPattern.getRouteRef().getRef();
            lineRef = ((LineRefStructure)this.routeById.lookup(routeRef).getLineRef().getValue()).getRef();
        }
        org.opentripplanner.model.Route route = this.otpRouteById.get(this.idFactory.createId(lineRef));
        if (route == null) {
            LOG.warn("Unable to link ServiceJourney to Route. ServiceJourney id: " + serviceJourney.getId() + ", Line ref: " + lineRef);
        }
        return route;
    }

    @Nullable
    private Operator findOperator(ServiceJourney serviceJourney) {
        OperatorRefStructure opeRef = serviceJourney.getOperatorRef();
        if (opeRef == null) {
            return null;
        }
        return this.operatorsById.get(this.idFactory.createId(opeRef.getRef()));
    }
}

