/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMap;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMapById;
import org.opentripplanner.netex.index.hierarchy.HierarchicalMap;
import org.opentripplanner.netex.issues.ObjectNotFound;
import org.opentripplanner.netex.mapping.calendar.CalendarServiceBuilder;
import org.opentripplanner.netex.mapping.calendar.DatedServiceJourneyMapper;
import org.opentripplanner.netex.mapping.calendar.DayTypeAssignmentMapper;
import org.rutebanken.netex.model.DatedServiceJourney;
import org.rutebanken.netex.model.DayType;
import org.rutebanken.netex.model.DayTypeAssignment;
import org.rutebanken.netex.model.DayTypeRefStructure;
import org.rutebanken.netex.model.DayTypeRefs_RelStructure;
import org.rutebanken.netex.model.OperatingDay;
import org.rutebanken.netex.model.OperatingPeriod;
import org.rutebanken.netex.model.ServiceJourney;

public class TripCalendarBuilder {
    private final CalendarServiceBuilder calendarServiceBuilder;
    private final DataImportIssueStore issueStore;
    private HierarchicalMap<String, Set<ServiceDate>> dayTypeCalendars = new HierarchicalMap();
    private HierarchicalMap<String, Set<ServiceDate>> dsjBySJId = new HierarchicalMap();

    public TripCalendarBuilder(CalendarServiceBuilder calendarServiceBuilder, DataImportIssueStore issueStore) {
        this.calendarServiceBuilder = calendarServiceBuilder;
        this.issueStore = issueStore;
    }

    public void push() {
        this.dayTypeCalendars = new HierarchicalMap<String, Set<ServiceDate>>(this.dayTypeCalendars);
        this.dsjBySJId = new HierarchicalMap<String, Set<ServiceDate>>(this.dsjBySJId);
    }

    public void pop() {
        this.dayTypeCalendars = this.dayTypeCalendars.parent();
        this.dsjBySJId = this.dsjBySJId.parent();
    }

    public void addDayTypeAssignments(ReadOnlyHierarchicalMapById<DayType> dayTypeById, ReadOnlyHierarchicalMap<String, Collection<DayTypeAssignment>> dayTypeAssignmentByDayTypeId, ReadOnlyHierarchicalMapById<OperatingDay> operatingDays, ReadOnlyHierarchicalMapById<OperatingPeriod> operatingPeriodById) {
        this.dayTypeCalendars.addAll(DayTypeAssignmentMapper.mapDayTypes(dayTypeById, dayTypeAssignmentByDayTypeId, operatingDays, operatingPeriodById, this.issueStore));
    }

    void addDatedServiceJourneys(ReadOnlyHierarchicalMapById<OperatingDay> operatingDayById, Map<String, List<DatedServiceJourney>> datedServiceJourneyBySJId) {
        for (String sjId : datedServiceJourneyBySJId.keySet()) {
            if (!this.dsjBySJId.containsKey(sjId)) {
                this.dsjBySJId.add(sjId, new HashSet());
            }
            ((Set)this.dsjBySJId.lookup(sjId)).addAll(DatedServiceJourneyMapper.mapToServiceDates((Iterable<DatedServiceJourney>)datedServiceJourneyBySJId.get(sjId), operatingDayById));
        }
    }

    Map<String, FeedScopedId> createTripCalendar(Iterable<ServiceJourney> serviceJourneys) {
        HashMap<String, FeedScopedId> serviceIdsBySJId = new HashMap<String, FeedScopedId>();
        for (ServiceJourney sj : serviceJourneys) {
            HashSet<ServiceDate> serviceDates = new HashSet<ServiceDate>(this.getServiceDatesForDayType(sj));
            serviceDates.addAll(this.getDatesForDSJs(sj.getId()));
            FeedScopedId serviceId = this.calendarServiceBuilder.registerDatesAndGetServiceId(serviceDates);
            serviceIdsBySJId.put(sj.getId(), serviceId);
        }
        return serviceIdsBySJId;
    }

    private Collection<ServiceDate> getServiceDatesForDayType(ServiceJourney sj) {
        DayTypeRefs_RelStructure dayTypes = sj.getDayTypes();
        if (dayTypes == null) {
            return List.of();
        }
        ArrayList<ServiceDate> result = new ArrayList<ServiceDate>();
        for (JAXBElement dt : dayTypes.getDayTypeRef()) {
            String dayTypeRef = ((DayTypeRefStructure)dt.getValue()).getRef();
            Set dates = (Set)this.dayTypeCalendars.lookup(dayTypeRef);
            if (dates != null) {
                result.addAll(dates);
                continue;
            }
            this.reportSJDayTypeNotFound(sj, dayTypeRef);
        }
        return result;
    }

    private Collection<ServiceDate> getDatesForDSJs(String sjId) {
        return this.dsjBySJId.containsKey(sjId) ? (Collection)this.dsjBySJId.lookup(sjId) : List.of();
    }

    private void reportSJDayTypeNotFound(ServiceJourney sj, String dayTypeRef) {
        this.issueStore.add(new ObjectNotFound("ServiceJourney", sj.getId(), "DayTypes", dayTypeRef));
    }
}

