/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import org.opentripplanner.common.model.T2;
import org.opentripplanner.model.TransitMode;
import org.rutebanken.netex.model.AllVehicleModesOfTransportEnumeration;
import org.rutebanken.netex.model.TransportSubmodeStructure;

class TransportModeMapper {
    TransportModeMapper() {
    }

    public T2<TransitMode, String> map(AllVehicleModesOfTransportEnumeration netexMode, TransportSubmodeStructure submode) {
        if (submode != null) {
            return this.getSubmodeAsString(submode);
        }
        return new T2<TransitMode, Object>(this.mapAllVehicleModesOfTransport(netexMode), null);
    }

    private TransitMode mapAllVehicleModesOfTransport(AllVehicleModesOfTransportEnumeration mode) {
        switch (mode) {
            case AIR: {
                return TransitMode.AIRPLANE;
            }
            case BUS: 
            case TAXI: {
                return TransitMode.BUS;
            }
            case CABLEWAY: {
                return TransitMode.CABLE_CAR;
            }
            case COACH: {
                return TransitMode.COACH;
            }
            case FUNICULAR: {
                return TransitMode.FUNICULAR;
            }
            case METRO: {
                return TransitMode.SUBWAY;
            }
            case RAIL: {
                return TransitMode.RAIL;
            }
            case TRAM: {
                return TransitMode.TRAM;
            }
            case WATER: {
                return TransitMode.FERRY;
            }
        }
        throw new IllegalArgumentException(mode.toString());
    }

    private T2<TransitMode, String> getSubmodeAsString(TransportSubmodeStructure submode) {
        if (submode.getAirSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.AIRPLANE, submode.getAirSubmode().value());
        }
        if (submode.getBusSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.BUS, submode.getBusSubmode().value());
        }
        if (submode.getTelecabinSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.GONDOLA, submode.getTelecabinSubmode().value());
        }
        if (submode.getCoachSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.COACH, submode.getCoachSubmode().value());
        }
        if (submode.getFunicularSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.FUNICULAR, submode.getFunicularSubmode().value());
        }
        if (submode.getMetroSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.SUBWAY, submode.getMetroSubmode().value());
        }
        if (submode.getRailSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.RAIL, submode.getRailSubmode().value());
        }
        if (submode.getTramSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.TRAM, submode.getTramSubmode().value());
        }
        if (submode.getWaterSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.FERRY, submode.getWaterSubmode().value());
        }
        throw new IllegalArgumentException();
    }
}

