/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import com.google.common.collect.ArrayListMultimap;
import javax.annotation.Nullable;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.impl.EntityById;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.model.transfer.TransferPriority;
import org.opentripplanner.model.transfer.TripTransferPoint;
import org.opentripplanner.netex.issues.InterchangeMaxWaitTimeNotGuaranteed;
import org.opentripplanner.netex.issues.InterchangePointMappingFailed;
import org.opentripplanner.netex.issues.InterchangeWithoutConstraint;
import org.opentripplanner.netex.issues.ObjectNotFound;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.rutebanken.netex.model.ScheduledStopPointRefStructure;
import org.rutebanken.netex.model.ServiceJourneyInterchange;
import org.rutebanken.netex.model.VehicleJourneyRefStructure;

public class TransferMapper {
    private final FeedScopedIdFactory idFactory;
    private final DataImportIssueStore issueStore;
    private final ArrayListMultimap<String, String> scheduledStopPointsIndex;
    private final EntityById<Trip> trips;

    public TransferMapper(FeedScopedIdFactory idFactory, DataImportIssueStore issueStore, ArrayListMultimap<String, String> scheduledStopPointsIndex, EntityById<Trip> trips) {
        this.idFactory = idFactory;
        this.issueStore = issueStore;
        this.scheduledStopPointsIndex = scheduledStopPointsIndex;
        this.trips = trips;
    }

    @Nullable
    public ConstrainedTransfer mapToTransfer(ServiceJourneyInterchange it) {
        String id = it.getId();
        TripTransferPoint from = this.mapPoint("from", id, it.getFromJourneyRef(), it.getFromPointRef());
        TripTransferPoint to = this.mapPoint("to", id, it.getToJourneyRef(), it.getToPointRef());
        if (from == null || to == null) {
            return null;
        }
        TransferConstraint c = this.mapConstraint(it);
        ConstrainedTransfer tx = new ConstrainedTransfer(this.idFactory.createId(it.getId()), from, to, c);
        if (tx.noConstraints()) {
            this.issueStore.add(new InterchangeWithoutConstraint(tx));
            return null;
        }
        return tx;
    }

    @Nullable
    private TripTransferPoint mapPoint(String label, String interchangeId, VehicleJourneyRefStructure sjRef, ScheduledStopPointRefStructure pointRef) {
        String sjId = sjRef.getRef();
        Trip trip = this.findTrip(label + "Journey", interchangeId, sjId);
        int stopPos = this.findStopPosition(interchangeId, label + "Point", sjId, pointRef);
        return trip == null || stopPos < 0 ? null : new TripTransferPoint(trip, stopPos);
    }

    @Nullable
    private Trip findTrip(String fieldName, String rootId, String sjId) {
        FeedScopedId tripId = this.createId(sjId);
        Trip trip = this.trips.get(tripId);
        return this.assertRefExist(fieldName, rootId, sjId, trip) ? trip : null;
    }

    private TransferConstraint mapConstraint(ServiceJourneyInterchange it) {
        TransferConstraint.Builder cBuilder = TransferConstraint.create();
        if (it.isStaySeated() != null) {
            cBuilder.staySeated(it.isStaySeated());
        }
        if (it.isGuaranteed() != null) {
            cBuilder.guaranteed(it.isGuaranteed());
        }
        if (it.getPriority() != null) {
            cBuilder.priority(this.mapPriority(it.getPriority()));
        }
        if (it.getMaximumWaitTime() != null) {
            if (it.isGuaranteed().booleanValue()) {
                cBuilder.maxWaitTime((int)it.getMaximumWaitTime().toSeconds());
            } else {
                this.issueStore.add(new InterchangeMaxWaitTimeNotGuaranteed(it));
            }
        }
        return cBuilder.build();
    }

    private TransferPriority mapPriority(Number pri) {
        switch (pri.intValue()) {
            case -1: {
                return TransferPriority.NOT_ALLOWED;
            }
            case 0: {
                return TransferPriority.ALLOWED;
            }
            case 1: {
                return TransferPriority.RECOMMENDED;
            }
            case 2: {
                return TransferPriority.PREFERRED;
            }
        }
        throw new IllegalArgumentException("Interchange priority unknown: " + pri);
    }

    private int findStopPosition(String interchangeId, String label, String sjId, ScheduledStopPointRefStructure scheduledStopPointRef) {
        String sspId = scheduledStopPointRef.getRef();
        int index = this.scheduledStopPointsIndex.get((Object)sjId).indexOf(sspId);
        if (index >= 0) {
            return index;
        }
        String detailedMsg = this.scheduledStopPointsIndex.containsKey((Object)sjId) ? "Scheduled-stop-point-ref not found" : "Service-journey not found";
        this.issueStore.add(new InterchangePointMappingFailed(detailedMsg, interchangeId, label, sjId, sspId));
        return index;
    }

    private FeedScopedId createId(String id) {
        return this.idFactory.createId(id);
    }

    private <T> boolean assertRefExist(String fieldName, String interchangeId, String id, T instance) {
        if (instance == null) {
            this.issueStore.add(new ObjectNotFound("Interchange", interchangeId, fieldName, id));
            return false;
        }
        return true;
    }
}

