/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opentripplanner.model.FareZone;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalVersionMapById;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.rutebanken.netex.model.TariffZone;
import org.rutebanken.netex.model.TariffZoneRef;
import org.rutebanken.netex.model.VersionOfObjectRefStructure;

class TariffZoneMapper {
    private final LocalDateTime startOfPeriod;
    private final FeedScopedIdFactory idFactory;
    private final ReadOnlyHierarchicalVersionMapById<TariffZone> tariffZonesById;
    private final Multimap<FeedScopedId, FareZone> deduplicateCache = ArrayListMultimap.create();

    TariffZoneMapper(LocalDateTime startOfPeriod, FeedScopedIdFactory idFactory, ReadOnlyHierarchicalVersionMapById<TariffZone> tariffZonesById) {
        this.startOfPeriod = startOfPeriod;
        this.idFactory = idFactory;
        this.tariffZonesById = tariffZonesById;
    }

    Collection<FareZone> listAllCurrentFareZones() {
        return this.tariffZonesById.localListCurrentVersionEntities(this.startOfPeriod).stream().map(this::mapTariffZone).collect(Collectors.toUnmodifiableList());
    }

    FareZone findAndMapTariffZone(TariffZoneRef ref) {
        TariffZone tariffZone = this.tariffZonesById.lookup((VersionOfObjectRefStructure)ref, this.startOfPeriod);
        return tariffZone == null ? null : this.mapTariffZone(tariffZone);
    }

    private FareZone mapTariffZone(TariffZone tariffZone) {
        if (tariffZone == null) {
            return null;
        }
        FeedScopedId id = this.idFactory.createId(tariffZone.getId());
        String name = tariffZone.getName().getValue();
        return this.deduplicate(new FareZone(id, name));
    }

    private FareZone deduplicate(FareZone candidate) {
        Optional<FareZone> existing = this.deduplicateCache.get((Object)candidate.getId()).stream().filter(candidate::sameValueAs).findFirst();
        if (existing.isPresent()) {
            return existing.get();
        }
        this.deduplicateCache.put((Object)candidate.getId(), (Object)candidate);
        return candidate;
    }
}

