/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.Collection;
import javax.annotation.Nullable;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.model.FareZone;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.WgsCoordinate;
import org.opentripplanner.netex.issues.QuayWithoutCoordinates;
import org.opentripplanner.netex.mapping.WgsCoordinateMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.rutebanken.netex.model.Quay;

class StopMapper {
    private final DataImportIssueStore issueStore;
    private final FeedScopedIdFactory idFactory;

    StopMapper(FeedScopedIdFactory idFactory, DataImportIssueStore issueStore) {
        this.idFactory = idFactory;
        this.issueStore = issueStore;
    }

    @Nullable
    Stop mapQuayToStop(Quay quay, Station parentStation, Collection<FareZone> fareZones, T2<TransitMode, String> transitMode) {
        WgsCoordinate coordinate = WgsCoordinateMapper.mapToDomain(quay.getCentroid());
        if (coordinate == null) {
            this.issueStore.add(new QuayWithoutCoordinates(quay.getId()));
            return null;
        }
        Stop stop = new Stop(this.idFactory.createId(quay.getId()), parentStation.getName(), quay.getPublicCode(), quay.getDescription() != null ? quay.getDescription().getValue() : null, WgsCoordinateMapper.mapToDomain(quay.getCentroid()), null, null, null, fareZones, null, null, (TransitMode)((Object)transitMode.first), (String)transitMode.second);
        stop.setParentStation(parentStation);
        return stop;
    }
}

