/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableInt;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.MissingProjectionInServiceLink;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.ShapePoint;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMap;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMapById;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalVersionMapById;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.LinkInLinkSequence_VersionedChildStructure;
import org.rutebanken.netex.model.LinkSequenceProjection_VersionStructure;
import org.rutebanken.netex.model.Quay;
import org.rutebanken.netex.model.ServiceLink;
import org.rutebanken.netex.model.ServiceLinkInJourneyPattern_VersionedChildStructure;

class ServiceLinkMapper {
    private final FeedScopedIdFactory idFactory;
    private final DataImportIssueStore issueStore;

    ServiceLinkMapper(FeedScopedIdFactory idFactory, DataImportIssueStore issueStore) {
        this.idFactory = idFactory;
        this.issueStore = issueStore;
    }

    Collection<ShapePoint> getShapePointsByJourneyPattern(JourneyPattern journeyPattern, ReadOnlyHierarchicalMapById<ServiceLink> serviceLinkById, ReadOnlyHierarchicalMap<String, String> quayIdByStopPointRef, ReadOnlyHierarchicalVersionMapById<Quay> quayById) {
        ArrayList<ShapePoint> shapePoints = new ArrayList<ShapePoint>();
        if (journeyPattern.getLinksInSequence() != null) {
            MutableInt sequenceCounter = new MutableInt(0);
            MutableDouble distance = new MutableDouble(0.0);
            for (LinkInLinkSequence_VersionedChildStructure linkInLinkSequence_versionedChildStructure : journeyPattern.getLinksInSequence().getServiceLinkInJourneyPatternOrTimingLinkInJourneyPattern()) {
                String serviceLinkRef = ((ServiceLinkInJourneyPattern_VersionedChildStructure)linkInLinkSequence_versionedChildStructure).getServiceLinkRef().getRef();
                ServiceLink serviceLink = (ServiceLink)serviceLinkById.lookup(serviceLinkRef);
                if (serviceLink != null) {
                    shapePoints.addAll(this.mapServiceLink(serviceLink, journeyPattern, sequenceCounter, distance, quayIdByStopPointRef, quayById));
                    continue;
                }
                this.issueStore.add("MissingServiceLink", "ServiceLink not found in journey pattern %s", journeyPattern.getId());
            }
        }
        return shapePoints;
    }

    private Collection<ShapePoint> mapServiceLink(ServiceLink serviceLink, JourneyPattern journeyPattern, MutableInt sequenceCounter, MutableDouble distanceCounter, ReadOnlyHierarchicalMap<String, String> quayIdByStopPointRef, ReadOnlyHierarchicalVersionMapById<Quay> quayById) {
        ArrayList<ShapePoint> shapePoints = new ArrayList<ShapePoint>();
        FeedScopedId shapePointIdFromJourneyPatternId = this.createShapePointIdFromJourneyPatternId(this.idFactory.createId(journeyPattern.getId()));
        if (serviceLink.getProjections() == null || serviceLink.getProjections().getProjectionRefOrProjection() == null) {
            this.addStraightLine(serviceLink, sequenceCounter, distanceCounter, quayIdByStopPointRef, quayById, shapePoints, shapePointIdFromJourneyPatternId);
        } else {
            this.mapCoordinates(serviceLink, sequenceCounter, distanceCounter, shapePoints, shapePointIdFromJourneyPatternId);
        }
        return shapePoints;
    }

    private void mapCoordinates(ServiceLink serviceLink, MutableInt sequenceCounter, MutableDouble distanceCounter, Collection<ShapePoint> shapePoints, FeedScopedId shapePointIdFromJourneyPatternId) {
        for (JAXBElement projectionElement : serviceLink.getProjections().getProjectionRefOrProjection()) {
            Object projectionObj = projectionElement.getValue();
            if (!(projectionObj instanceof LinkSequenceProjection_VersionStructure)) continue;
            LinkSequenceProjection_VersionStructure linkSequenceProjection = (LinkSequenceProjection_VersionStructure)projectionObj;
            if (linkSequenceProjection.getLineString() != null) {
                List coordinates = linkSequenceProjection.getLineString().getPosList().getValue();
                double distance = serviceLink.getDistance() != null ? serviceLink.getDistance().doubleValue() : -1.0;
                for (int i = 0; i < coordinates.size(); i += 2) {
                    ShapePoint shapePoint = new ShapePoint();
                    shapePoint.setShapeId(shapePointIdFromJourneyPatternId);
                    shapePoint.setLat((Double)coordinates.get(i));
                    shapePoint.setLon((Double)coordinates.get(i + 1));
                    shapePoint.setSequence(sequenceCounter.toInteger());
                    if (distance != -1.0) {
                        shapePoint.setDistTraveled(distanceCounter.doubleValue() + distance / ((double)coordinates.size() / 2.0) * ((double)i / 2.0));
                    }
                    sequenceCounter.increment();
                    shapePoints.add(shapePoint);
                }
                distanceCounter.add(distance != -1.0 ? distance : 0.0);
                continue;
            }
            this.issueStore.add("ServiceLinkWithoutLineString", "Ignore linkSequenceProjection without linestring for: %s", linkSequenceProjection);
        }
    }

    private void addStraightLine(ServiceLink serviceLink, MutableInt sequenceCounter, MutableDouble distanceCounter, ReadOnlyHierarchicalMap<String, String> quayIdByStopPointRef, ReadOnlyHierarchicalVersionMapById<Quay> quayById, Collection<ShapePoint> shapePoints, FeedScopedId shapePointIdFromJourneyPatternId) {
        String fromPointQuayId = quayIdByStopPointRef.lookup(serviceLink.getFromPointRef().getRef());
        Quay fromPointQuay = quayById.lookupLastVersionById(fromPointQuayId);
        String toPointQuayId = quayIdByStopPointRef.lookup(serviceLink.getToPointRef().getRef());
        Quay toPointQuay = quayById.lookupLastVersionById(toPointQuayId);
        if (fromPointQuay != null && fromPointQuay.getCentroid() != null && toPointQuay != null && toPointQuay.getCentroid() != null) {
            double distance;
            this.issueStore.add(new MissingProjectionInServiceLink(serviceLink.getId()));
            ShapePoint fromShapePoint = new ShapePoint();
            fromShapePoint.setShapeId(shapePointIdFromJourneyPatternId);
            fromShapePoint.setLat(fromPointQuay.getCentroid().getLocation().getLatitude().doubleValue());
            fromShapePoint.setLon(fromPointQuay.getCentroid().getLocation().getLongitude().doubleValue());
            fromShapePoint.setSequence(sequenceCounter.toInteger());
            fromShapePoint.setDistTraveled(distanceCounter.getValue());
            shapePoints.add(fromShapePoint);
            sequenceCounter.increment();
            ShapePoint toShapePoint = new ShapePoint();
            toShapePoint.setShapeId(shapePointIdFromJourneyPatternId);
            toShapePoint.setLat(toPointQuay.getCentroid().getLocation().getLatitude().doubleValue());
            toShapePoint.setLon(toPointQuay.getCentroid().getLocation().getLongitude().doubleValue());
            toShapePoint.setSequence(sequenceCounter.toInteger());
            shapePoints.add(toShapePoint);
            sequenceCounter.increment();
            if (serviceLink.getDistance() != null) {
                distance = serviceLink.getDistance().doubleValue();
            } else {
                Coordinate fromCoord = new Coordinate(fromShapePoint.getLon(), fromShapePoint.getLat());
                Coordinate toCoord = new Coordinate(toShapePoint.getLon(), toShapePoint.getLat());
                distance = SphericalDistanceLibrary.distance(fromCoord, toCoord);
            }
            distanceCounter.add(distance);
            toShapePoint.setDistTraveled(distanceCounter.doubleValue());
        } else {
            this.issueStore.add("ServiceLinkWithoutQuay", "Ignore service link without projection and missing or unknown quays. Link: %s", serviceLink);
        }
    }

    private FeedScopedId createShapePointIdFromJourneyPatternId(FeedScopedId journeyPatternId) {
        return new FeedScopedId(journeyPatternId.getFeedId(), journeyPatternId.getId().replace("JourneyPattern", "ServiceLink"));
    }
}

