/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.BikeAccess;
import org.opentripplanner.model.Branding;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.impl.EntityById;
import org.opentripplanner.netex.index.api.NetexEntityIndexReadOnlyView;
import org.opentripplanner.netex.mapping.AuthorityToAgencyMapper;
import org.opentripplanner.netex.mapping.TransportModeMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.rutebanken.netex.model.AllVehicleModesOfTransportEnumeration;
import org.rutebanken.netex.model.BrandingRefStructure;
import org.rutebanken.netex.model.FlexibleLine_VersionStructure;
import org.rutebanken.netex.model.Line_VersionStructure;
import org.rutebanken.netex.model.Network;
import org.rutebanken.netex.model.OperatorRefStructure;
import org.rutebanken.netex.model.OrganisationRefStructure;
import org.rutebanken.netex.model.PresentationStructure;

class RouteMapper {
    private final DataImportIssueStore issueStore;
    private final HexBinaryAdapter hexBinaryAdapter = new HexBinaryAdapter();
    private final TransportModeMapper transportModeMapper = new TransportModeMapper();
    private final FeedScopedIdFactory idFactory;
    private final EntityById<Agency> agenciesById;
    private final EntityById<Operator> operatorsById;
    private final EntityById<Branding> brandingsById;
    private final NetexEntityIndexReadOnlyView netexIndex;
    private final AuthorityToAgencyMapper authorityMapper;
    private final Set<String> ferryIdsNotAllowedForBicycle;

    RouteMapper(DataImportIssueStore issueStore, FeedScopedIdFactory idFactory, EntityById<Agency> agenciesById, EntityById<Operator> operatorsById, EntityById<Branding> brandingsById, NetexEntityIndexReadOnlyView netexIndex, String timeZone, Set<String> ferryIdsNotAllowedForBicycle) {
        this.issueStore = issueStore;
        this.idFactory = idFactory;
        this.agenciesById = agenciesById;
        this.operatorsById = operatorsById;
        this.brandingsById = brandingsById;
        this.netexIndex = netexIndex;
        this.authorityMapper = new AuthorityToAgencyMapper(idFactory, timeZone);
        this.ferryIdsNotAllowedForBicycle = ferryIdsNotAllowedForBicycle;
    }

    Route mapRoute(Line_VersionStructure line) {
        Route otpRoute = new Route(this.idFactory.createId(line.getId()));
        otpRoute.setAgency(this.findOrCreateAuthority(line));
        otpRoute.setOperator(this.findOperator(line));
        otpRoute.setBranding(this.findBranding(line));
        otpRoute.setLongName(line.getName().getValue());
        otpRoute.setShortName(line.getPublicCode());
        T2<TransitMode, String> mode = this.transportModeMapper.map(line.getTransportMode(), line.getTransportSubmode());
        otpRoute.setMode((TransitMode)((Object)mode.first));
        otpRoute.setNetexSubmode((String)mode.second);
        if (line instanceof FlexibleLine_VersionStructure) {
            otpRoute.setFlexibleLineType(((FlexibleLine_VersionStructure)line).getFlexibleLineType().value());
        }
        if (line.getPresentation() != null) {
            PresentationStructure presentation = line.getPresentation();
            if (presentation.getColour() != null) {
                otpRoute.setColor(this.hexBinaryAdapter.marshal(presentation.getColour()));
            }
            if (presentation.getTextColour() != null) {
                otpRoute.setTextColor(this.hexBinaryAdapter.marshal(presentation.getTextColour()));
            }
        }
        if (line.getTransportMode().equals((Object)AllVehicleModesOfTransportEnumeration.WATER)) {
            if (this.ferryIdsNotAllowedForBicycle.contains(line.getId())) {
                otpRoute.setBikesAllowed(BikeAccess.NOT_ALLOWED);
            } else {
                otpRoute.setBikesAllowed(BikeAccess.ALLOWED);
            }
        }
        return otpRoute;
    }

    private Agency findOrCreateAuthority(Line_VersionStructure line) {
        String orgRef;
        Agency agency;
        String groupRef = line.getRepresentedByGroupRef().getRef();
        Network network = this.netexIndex.lookupNetworkForLine(groupRef);
        if (network != null && (agency = this.agenciesById.get(this.idFactory.createId(orgRef = ((OrganisationRefStructure)network.getTransportOrganisationRef().getValue()).getRef()))) != null) {
            return agency;
        }
        return this.createOrGetDummyAgency(line);
    }

    private Agency createOrGetDummyAgency(Line_VersionStructure line) {
        this.issueStore.add("LineWithoutAuthority", "No authority found for %s", line.getId());
        Agency agency = this.agenciesById.get(this.idFactory.createId(this.authorityMapper.dummyAgencyId()));
        if (agency == null) {
            agency = this.authorityMapper.createDummyAgency();
            this.agenciesById.add(agency);
        }
        return agency;
    }

    @Nullable
    private Operator findOperator(Line_VersionStructure line) {
        OperatorRefStructure opeRef = line.getOperatorRef();
        if (opeRef == null) {
            return null;
        }
        return this.operatorsById.get(this.idFactory.createId(opeRef.getRef()));
    }

    @Nullable
    private Branding findBranding(Line_VersionStructure line) {
        BrandingRefStructure brandingRef = line.getBrandingRef();
        if (brandingRef == null) {
            return null;
        }
        return this.brandingsById.get(this.idFactory.createId(brandingRef.getRef()));
    }
}

