/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Notice;
import org.opentripplanner.model.impl.EntityById;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;

class NoticeMapper {
    private final FeedScopedIdFactory idFactory;
    private final EntityById<Notice> cache = new EntityById();

    NoticeMapper(FeedScopedIdFactory idFactory) {
        this.idFactory = idFactory;
    }

    Notice map(org.rutebanken.netex.model.Notice netexNotice) {
        FeedScopedId id = this.idFactory.createId(netexNotice.getId());
        Notice otpNotice = this.cache.get(id);
        if (otpNotice == null) {
            otpNotice = new Notice(id);
            otpNotice.setText(netexNotice.getText().getValue());
            otpNotice.setPublicCode(netexNotice.getPublicCode());
            this.cache.add(otpNotice);
        }
        return otpNotice;
    }
}

